let socket;
let reconnectInterval = 3000; // Tiempo de espera entre intentos de reconexión (en ms)
let maxReconnectAttempts = 300; // Máximo número de intentos de reconexión
let reconnectAttempts = 0; // Contador de intentos actuales
let isManuallyClosed = false; // Para evitar reconexión si fue cerrado manualmente

function connectWebSocket() {
    socket = new WebSocket(`${websocket_URL}?user_id=${usuario_websocket}&store_id=${sucursal_logueo}&user_type=supplier`);

    socket.onopen = function () {
        console.log("Conexión establecida con el servidor.");
        agregarMensaje("Conectado al servidor");
        $('#websocket_status_icon').html(`<i class="icon-toggle-on text-success">WS Conectado</i>`);
        reconnectAttempts = 0; // Reset al conectar exitosamente
    };

    socket.onmessage = function (event) {
        let json = null;
        console.log("Mensaje recibido:", event.data);
        try {
            json = JSON.parse(event.data);
        } catch (e) {
            json = null;
        }

        if (json != null) {
            if (json.action && json.action === "update_supply_list") {
                if (!(
                    (localStorage.getItem('range_finished') && localStorage.getItem('range_finished') !== 'undefined') ||
                    (localStorage.getItem('supply_range_id') && localStorage.getItem('supply_range_id') !== 'undefined')
                )) {
                    const content = `<div>
                        <h3 class="text-center">Nuevo(s) Pedido(s)</h3>
                        <br>
                        <button type="button" class="btn btn-warning form-control" onclick="close_emergent();">
                            <i class="icon-ok-circled">Aceptar</i>
                        </button>
                    </div>`;
                    show_emergent(content);
                }
                alert_scann('new_supply');
                getInvoiceList();
            }
        } else {
            agregarMensaje("Servidor: " + event.data);
        }
    };

    socket.onerror = function (error) {
        console.error("Error en la conexión:", error);
        agregarMensaje("Error en la conexión");
    };

    socket.onclose = function () {
        $('#websocket_status_icon').html(`<i class="icon-toggle-off text-danger">WS Desconectado</i>`);
        console.log("Conexión cerrada");
        agregarMensaje("Conexión cerrada");

        // Intentar reconectar si no fue cerrado manualmente
        if (!isManuallyClosed && reconnectAttempts < maxReconnectAttempts) {
            reconnectAttempts++;
            console.log(`Intentando reconectar... (${reconnectAttempts}/${maxReconnectAttempts})`);
            setTimeout(connectWebSocket, reconnectInterval);
        } else if (reconnectAttempts >= maxReconnectAttempts) {
            console.warn("Máximo número de intentos de reconexión alcanzado.");
            agregarMensaje("No se pudo reconectar al servidor WebSocket.");
        }
    };
}

// Llamar a esta función para iniciar la conexión
connectWebSocket();

// Esta función puedes usarla si en algún momento quieres cerrar la conexión manualmente
function closeWebSocketManualmente() {
    isManuallyClosed = true;
    if (socket && socket.readyState === WebSocket.OPEN) {
        socket.close();
    }
}

// Enviar mensaje al servidor
function notificarPedidoTerminado(seller_id) {
    const mensaje = JSON.stringify({
        type: "supply_is_finished",
        user_type: "seller",
        user_id: seller_id
    });

    if (socket.readyState === WebSocket.OPEN) {
        socket.send(mensaje);
    } else {
        alert("La conexión no está abierta.");
    }
}

function agregarMensaje(texto) {
    console.log(texto);
    // Aquí puedes agregar lógica para mostrar mensajes en la interfaz
}

/*const socket = new WebSocket(`${websocket_URL}?user_id=${usuario_websocket}&store_id=${sucursal_logueo}&user_type=supplier`);//ws://localhost:8080//wss://192.168.1.253:8443/supplierws://192.168.1.253:8080
		socket.onopen = function () {
			console.log("Conexión establecida con el servidor.");
			agregarMensaje("Conectado al servidor");
            $('#websocket_status_icon').html(`<i class=\"icon-toggle-on text-success\">WS Conectado</i>`);
		};

		socket.onmessage = function (event) {
            //alert("here");
            json = null;
			console.log("Mensaje recibido:", event.data);
            try{
                json = JSON.parse(event.data);
            }catch(e){
                json = null;
            }
            console.log(json);
            if(json != null){
                if(json.action && json.action == "update_supply_list"){
                //alert("here");
                    if( ( localStorage.getItem('range_finished') != null && localStorage.getItem('range_finished') != undefined && localStorage.getItem('range_finished') != 'undefined')
                    || (localStorage.getItem('supply_range_id') != null && localStorage.getItem('supply_range_id') != undefined && localStorage.getItem('supply_range_id') != 'undefined') ){
                        
                    }else{
                        var content = `<div>
                            <h3 class="text-center">Nuevo(s) Pedido(s)</h3>
                            <br>
                            <button
                                type="button"
                                class="btn btn-warning form-control"
                                onclick="close_emergent();"
                            >
                                <i class="icon-ok-circled">Aceptar</i>
                            </button>
                        </div>`;
                        show_emergent(content);
                    }
                    alert_scann('new_supply');
                    getInvoiceList();
                }
            }else{
			    agregarMensaje("Servidor: " + event.data);
            }
		};

		socket.onerror = function (error) {
			console.error("Error en la conexión:", error);
			agregarMensaje("Error en la conexión");
		};

		socket.onclose = function () {
            $('#websocket_status_icon').html(`<i class=\"icon-toggle-off text-danger\">WS Desconectado</i>`);
			console.log("Conexión cerrada");
			agregarMensaje("Conexión cerrada");
		};

        function notificarPedidoTerminado(seller_id) {
            var mensaje = {"type" : "supply_is_finished", "user_type" : "seller", "user_id" : seller_id};
            mensaje = JSON.stringify(mensaje);
            //const input = document.getElementById("mensaje");
            //const mensaje = input.value;
            if (socket.readyState === WebSocket.OPEN) {
                socket.send(mensaje);
                //agregarMensaje(mensaje);
            } else {
                alert("La conexión no está abierta.");
            }
        }

		function agregarMensaje(texto) {
			console.log(texto);
		}*/