<?php

use GuzzleHttp\Psr7\Query;
// Manejo de la solicitud POST
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    //require_once '../../../../rest/src/config/db.php';
    require_once '../../../../conectMin.php';
    $surtimientoCRUD = new SurtimientoCRUD($link, $sucursal_id);
    $action = isset($_POST['action']) ? $_POST['action'] : '';
//obtener lista de surtimientos
    switch($action){
    //obtener lista de productos
        case 'getList' :
            $date_filter = (isset($_POST['date_filter']) ? $_POST['date_filter'] : $_GET['date_filter']);
            $status_filter = (isset($_POST['status_filter']) ? $_POST['status_filter'] : $_GET['status_filter']);
        //instacia de clase
            $list = $surtimientoCRUD->getSupplyList(null, null, $sucursal_id, $date_filter, null, $status_filter);
            echo (json_encode($list));
        break;
    //obtener productos de surtimiento
        case 'getSupplyProducts' :
            $supply_range_id = (isset($_POST['supply_range_id']) ? $_POST['supply_range_id'] : $_GET['supply_range_id']);
            $permission_change = (isset($_POST['permission_change']) ? $_POST['permission_change'] : $_GET['permission_change']);
            echo $surtimientoCRUD->setSuppplyRangeByUser($supply_range_id, $user_id, $sucursal_id, $permission_change );
        break;
    //verificar contraseña de encargado
        case 'checkMannagerPassword':
            $password = (isset($_POST['password']) ? $_POST['password'] : $_GET['password']);
            echo $surtimientoCRUD->checkMannagerPassword($sucursal_id, $password);
        break;
    //pausar surtimiento
        case 'exitSupply':
        //verifica Password de encargado
            $password = (isset($_POST['password']) ? $_POST['password'] : $_GET['password']);
            $password_validation = $surtimientoCRUD->checkMannagerPassword($sucursal_id, $password);
            $password_validation_decode = json_decode($password_validation, true);
            if($password_validation_decode['status'] != "200"){
                die($password_validation);
            }else{
                $supply_detail_id = (isset($_POST['supply_detail_id']) ? $_POST['supply_detail_id'] : $_GET['supply_detail_id']);
            //pausa surtimiento
                echo $surtimientoCRUD->exitSupply($supply_detail_id);
            }
        break;
    //actualizacion del detalle de surtimiento
        case 'updateSupplyDetail':
            $supply_detail_id = (isset($_POST['supply_detail_id']) ? $_POST['supply_detail_id'] : $_GET['supply_detail_id']);
            $supply_range_id = (isset($_POST['supply_range_id']) ? $_POST['supply_range_id'] : $_GET['supply_range_id']);
            $quantity = (isset($_POST['supply_quantity']) ? $_POST['supply_quantity'] : $_GET['supply_quantity']);
            $no_suplied = (isset($_POST['no_suplied']) ? $_POST['no_suplied'] : $_GET['no_suplied']);
            $partially_suplied = (isset($_POST['partially_suplied']) ? $_POST['partially_suplied'] : $_GET['partially_suplied']);
            $current_location_number = (isset($_POST['current_location_number']) ? $_POST['current_location_number'] : $_GET['current_location_number']);
            $current_location_letter = (isset($_POST['current_letter_number']) ? $_POST['current_letter_number'] : $_GET['current_letter_number']);
            echo $surtimientoCRUD->updateSupplyDetail($supply_detail_id, $quantity, $supply_range_id, $user_id, $sucursal_id, $no_suplied, 
                $partially_suplied, $current_location_number, $current_location_letter);
        break;
    //impresion de ticket de finalizacion de surtimiento
        case 'printFinishedTicket':
            $supply_range_id = (isset($_POST['supply_range_id']) ? $_POST['supply_range_id'] : $_GET['supply_range_id']);
            echo $surtimientoCRUD->printFinishedTicket($supply_range_id, $sucursal_id, $user_id, $rootpath, $user_tipo_sistema);
        break;
    //impresion de ticket de pausado de surtimiento
        case 'printPausedTicket':
            $supply_range_id = (isset($_POST['supply_range_id']) ? $_POST['supply_range_id'] : $_GET['supply_range_id']);
            echo $surtimientoCRUD->printPausedTicket($supply_range_id, $sucursal_id, $user_id, $rootpath, $user_tipo_sistema);
        break;
    //
        case 'updateRangeSuppyStatus':
            $supply_range_id = (isset($_POST['supply_range_id']) ? $_POST['supply_range_id'] : $_GET['supply_range_id']);
            $status = (isset($_POST['status']) ? $_POST['status'] : $_GET['status']);
            echo $surtimientoCRUD->updateRangeSuppyStatus($supply_range_id, $status);
        break;
    //caso default
        default:
            echo "Permission denied on '{$action}'.";
        break;
    }
}

class SurtimientoCRUD {
    private $link;
    private $store_id;
    private $Logger;

    public function __construct($connection, $store_id) {
        $this->link = $connection;
        $this->store_id = $store_id;
        $this->Logger = $this->getLogConfig();
    }

    function getLogConfig(){
        $resp = null;
        try{
            $sql = "SELECT habilitar_log FROM sys_menus WHERE id_menu = 312";
            $stm = $this->link->query($sql);
            $row =  $stm->fetch(PDO::FETCH_ASSOC);
            $resp = ($row['habilitar_log'] == 1 || $row['habilitar_log'] == '1' ? true : false );
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar configuracion del log para el menu.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        return $resp;
    }

/*
    Oscar 2025-06-19
*/
    function getWSURL(){
        try{
			$WSsql = "SELECT `value` FROM api_config WHERE id = '23'";
			$WSstm = $this->link->query($WSsql);
			$WSrow = $WSstm->fetch(PDO::FETCH_ASSOC);
			return "var websocket_URL = '{$WSrow['value']}';";
		}catch(PDOException $error){
			die("Error al consultar URL de WebSocket : {$WSsql} : {$error->getMessage()}");
		}
    }
    public function checkMannagerPassword($store_id, $password){
        try{
            $sql = "SELECT
                        u.id_usuario
                    FROM sys_sucursales s
                    LEFT JOIN sys_users u
                    ON s.id_encargado = u.id_usuario
                    WHERE s.id_sucursal = {$store_id}
                    AND u.contrasena = md5('{$password}')";
            $stm = $this->link->query($sql);
            if($stm->rowCount() <= 0){
                return json_encode(array("status"=>"invalid_password", "message"=>"Contraseña de encargado incorrecta."));
            }
        }catch(PDOException $error){
            return json_encode(array("status"=>"302", "message"=>"Error al verificar contraseña de encargado.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}"));
        }
        return json_encode(array("status"=>"200", "message"=>"Contraseña de encargado correcta."));
    }

    public function getInvoiceStatus(){
        $status = array();
        $status[] = array("id_status_surtimiento_pedido"=>-1, "descripcion_status"=>"Todos");
        try{
            $sql = "SELECT
                    id_status_surtimiento_pedido,
                    descripcion_status
            FROM ec_status_surtimiento_pedido";
            foreach($this->link->query($sql) AS $row){
                $status[] = $row;
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>302, "message"=>"Error al consultar status de surtimiento.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
        }
        return $status;
    }

    public function getSupplyList($perfil=null,$idUsuario=null,$sucursal=null,$fecha=null,$tipo=null,$estado=null) {
        $suplies = array();
        $counters = array();
    //consulta dettalle de pendientes de surtir
        try{
            $sql = "(SELECT
                        COUNT(s.id) AS counter_1
                    FROM ec_surtimiento s
                    WHERE s.estado = 1
                    )UNION ALL
                    (SELECT
                        COUNT(spr.id_surtimiento_por_rango) AS counter_2
                    FROM ec_surtimiento_por_rangos spr
                    WHERE spr.id_status_surtimiento_pedidos IN(1,2)
                    )UNION ALL(
                        SELECT
                            COUNT(sd.id) AS counter_3
                        FROM ec_surtimiento_detalle sd             
                        WHERE sd.estado = 1
                    )";
            foreach($this->link->query($sql) as $row){
                $counters[] = $row;
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar contadores de pendientes de surtir.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        
    //consulta los rangos de ubicaciondes de la sucursal
        $store_locations_ranges = array();
        $sql = "SELECT
                    id_rango_ubicacion_sucursal,
                    CONCAT(desde, '-', hasta) AS location_range
                FROM ec_rangos_ubicaciones_sucursales
                WHERE id_sucursal = {$sucursal}";
        try{
            foreach($this->link->query($sql) AS $row){
                $store_locations_ranges[] = $row;
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar los rangos de ubicaciones.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        
        //$estado = ($estado == '') ? "'1','2','4'" : $estado;
        $estado = ($estado == '' || $estado == null|| $estado == -1) ? "'1','2','3', 4, 5" : $estado;
        //$estado = ($estado == '-1') ? "'1','2','3','4','5'" : $estado;
        //$estado = ($estado == 'Cerrados') ? "'3','5'" : $estado;
        $filters = ' ';
        //$filters = empty($tipo) ? $filters : $filters . " AND s.tipo = '{$tipo}' ";
        //$filters = empty($estado) ? $filters : $filters . " AND s.estado in ({$estado}) ";
        $filters = empty($fecha) ? $filters : $filters . " AND date(s.fecha_creacion) >= '{$fecha}' ";
        //$estados = $perfil=='2' ? "'1','2','3','4','5'" : "'1','2','3'" ;
        $sql = "SELECT 
                s.id,
                s.no_pedido,
                CASE 
                    WHEN s.tipo = 1 THEN 'Muestra'
                    WHEN s.tipo = 2 THEN 'Pedido'
                    ELSE s.tipo
                END AS tipo,
                ssp.descripcion_status AS estado,
                s.estado supply_status_id,
                concat(u.nombre, ' ', u.apellido_paterno) AS nombre_vendedor,
                s.rango_ubicaciones
            FROM ec_surtimiento s
            LEFT JOIN ec_status_surtimiento_pedido ssp
            ON ssp.id_status_surtimiento_pedido = s.estado
            LEFT JOIN sys_users u 
            ON u.id_usuario = s.id_vendedor
            LEFT JOIN ec_surtimiento_detalle sd 
            ON sd.id_surtimiento = s.id
            LEFT JOIN ec_surtimiento_por_rangos spr
            ON spr.id_surtimiento_por_rango = sd.id_surtimiento_por_rango
            LEFT JOIN sys_users us 
            ON us.id_usuario = sd.id_asignado
            WHERE s.id_sucursal = '{$sucursal}'
            AND spr.id_status_surtimiento_pedidos in ({$estado})
            {$filters}
            GROUP BY s.id
            ORDER BY s.fecha_modificacion ASC";//s.fecha_creacion, s.estado, s.prioridad // $result = $this->link->query($sql);
        foreach($this->link->query($sql) AS $row){
            $row['supply_detail'] = $store_locations_ranges;
            foreach($row['supply_detail'] as $key => $row_location){
                $row['supply_detail'][$key]['detail'] = $this->getSupplyRangesDetail($row['supply_detail'][$key]['id_rango_ubicacion_sucursal'], $row['id']);
            }
        //consulta detalles del surtimiento
            
            $suplies[] = $row;
        }
        return array("counters"=>$counters,"supplies"=>$suplies);//$result->fetchAll(PDO::FETCH_ASSOC);
    }
    public function getSupplyRangesDetail($location_range_id, $supply_id){
        try{
            $sql = "SELECT
                        id_surtimiento_por_rango,
                        id_usuario_asignado,
                        id_status_surtimiento_pedidos AS range_status
                    FROM ec_surtimiento_por_rangos
                    WHERE id_rango_ubicacion_sucursal = {$location_range_id}
                    AND id_surtimiento = {$supply_id}";
            $stm = $this->link->query($sql);
            if($stm->rowcount() <= 0){
                return null;
            }else{
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                return $row;
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar surtimiento por rangos.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
    }
    public function getWebSocketURL(){
        try{
            $sql = "SELECT url_websocket_pagos FROM sys_configuracion_sistema LIMIT 1";
            $stm = $this->link->query( $sql );
            $row = $stm->fetch(PDO::FETCH_ASSOC);//_assoc()
            return $row['url_websocket_pagos'];
        }catch(PDOException $error){
            die( "Error al consultar la URL de los WebSockets  de pagos : {$sql} : {$error}" );
        }
    }
    public function setSuppplyRangeByUser($supply_range_id, $user_id, $store_id, $permission_change = 'false'){
    //consulta si se esta tomando el rango correcto de acuerdo al orden
        if($permission_change == 'false'){
            try{
                $sql = "SELECT
                        spr.id_surtimiento_por_rango AS next_supply_id,
                        ax.id_status_surtimiento_pedidos AS current_supply_status,
                        spr.id_surtimiento AS supply_id,
                        ax.id_surtimiento AS current_supply_id,
                        ax.id_usuario_asignado AS current_supply_user_id
                    FROM(
                        SELECT
                            spr.id_rango_ubicacion_sucursal,
                            spr.id_status_surtimiento_pedidos,
                            spr.id_surtimiento,
                            spr.id_usuario_asignado
                        FROM ec_surtimiento_por_rangos spr
                        WHERE spr.id_surtimiento_por_rango = {$supply_range_id}

                    )ax
                    LEFT JOIN ec_surtimiento_por_rangos spr
                    ON ax.id_rango_ubicacion_sucursal = spr.id_rango_ubicacion_sucursal
                    RIGHT JOIN ec_surtimiento s 
                    ON spr.id_surtimiento = s.id
                    WHERE spr.id_status_surtimiento_pedidos IN(1)
                    AND spr.id_rango_ubicacion_sucursal = ax.id_rango_ubicacion_sucursal
                    AND DATE(spr.fecha_alta) = DATE(NOW())/*Filtro de fecha*/
                    ORDER BY s.fecha_creacion, s.estado, s.prioridad ASC
                    LIMIT 1";
                $stm = $this->link->query($sql);
                if($stm->rowCount() > 0){
                    $row = $stm->fetch(PDO::FETCH_ASSOC);
                    if($row['next_supply_id'] != $supply_range_id && $row['current_supply_status'] == 1 && ($row['current_supply_user_id'] == 'NULL' || $row['current_supply_user_id'] == '' )){//si es status 1 y diferente id tomado del siguiente
                        die(json_encode(array("status"=>"incorrect_supply", "detail"=>$row)));
                    }
                }
            }catch(PDOException $error){
                die(json_encode(array("status"=>200, "message"=>"Error al validar orden de surtimiento.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            }
        }
    //consulta que no hay un usuario asignado
        try{
            $sql = "SELECT
                        IF(spr.id_usuario_asignado IS NULL, -1, spr.id_usuario_asignado) AS assigned_user_id,
                        CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) AS user_name,
                        spr.id_status_surtimiento_pedidos AS status_id
                    FROM ec_surtimiento_por_rangos spr
                    LEFT JOIN sys_users u
                    ON u.id_usuario = spr.id_usuario_asignado
                    WHERE spr.id_surtimiento_por_rango = {$supply_range_id}";
            $stm = $this->link->query($sql);
            $row = $stm->fetch(PDO::FETCH_ASSOC);
//echo "if({$row['assigned_user_id']} != -1 && {$row['assigned_user_id']} != '' && {$row['assigned_user_id']} != null && {$row['assigned_user_id']} != {$user_id} && ( {$permission_change} == false || {$permission_change} == 'false' )  AND {$row['status_id']} > 1)";
            if($row['assigned_user_id'] != -1 && $row['assigned_user_id'] != '' && $row['assigned_user_id'] != null && $row['assigned_user_id'] != $user_id 
            && ( $permission_change == false || $permission_change == 'false' )  AND $row['status_id'] > 1){
                return json_encode(array("status"=>"incorrect_user", "current_user"=>$row['user_name']));
            }//die("pasa : if({$row['assigned_user_id']} != -1 && {$row['assigned_user_id']} != '' && {$row['assigned_user_id']} != null && {$row['assigned_user_id']} != {$user_id} && ( {$permission_change} == false || {$permission_change} == 'false' )  AND {$row['status_id']} > 1)");
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302","message"=>"Error al consultar si hay usuario asignado previamente al surtimiento.", "query"=>"{$sql}", "error_detail"=>$error->getMessage())));
        }
    //asigna el rango y el detalle al usuario
        try{
            $sql = "UPDATE ec_surtimiento_por_rangos spr
                    LEFT JOIN ec_surtimiento_detalle sd 
                    ON spr.id_surtimiento_por_rango = sd.id_surtimiento_por_rango
                    LEFT JOIN ec_surtimiento s
                    ON sd.id_surtimiento = s.id
                        SET spr.id_usuario_asignado = {$user_id},
                        sd.id_asignado = {$user_id},
                        s.estado = 2,
                        spr.id_status_surtimiento_pedidos = 2
                    WHERE spr.id_surtimiento_por_rango = {$supply_range_id}";//AND sd.cantidad_surtida IS NULL
            $this->link->query($sql);
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302","message"=>"Error al asignar el usuario al surtimiento.", "query"=>"{$sql}", "error_detail"=>$error->getMessage())));
        }
    //consulta el producto que tiene que enviar
        return $this->getNextSupplyDetail($supply_range_id, $user_id, $store_id);
    }

    public function getNextSupplyDetail($supply_range_id, $user_id, $store_id, $current_location_number = 0, $current_location_letter = ""){
if($this->Logger){
    error_log("Entra en getNextSupplyDetail-1.");
}
        $supply_product = array();
        $supply_counters = array();
        try{
            $sql = "SELECT 
                        COUNT(*) AS details_total,
                        (SUM(IF(sd.cantidad_surtida IS NULL 
                        OR ( sd.cantidad_solicitada > sd.cantidad_surtida AND sd.surtido_parcialmente = 0) 
                        OR ( sd.cantidad_surtida = 0 AND sd.no_se_surte = 0) , 0, 1)) + 1) AS current_supply_counter
                    FROM ec_surtimiento_detalle sd
                    WHERE sd.id_surtimiento_por_rango = {$supply_range_id}";
            $stm = $this->link->query($sql);
            $supply_counters = $stm->fetch(PDO::FETCH_ASSOC);
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar contadores del rango por surtir.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        try{
            $sql = "SELECT
                        sd.id_surtimiento AS supply_id,
                        sd.id AS supply_detail_id,
                        p.id_productos AS product_id,
                        CONCAT('(', p.orden_lista, ') ', p.nombre)AS product_name,
                        UPPER( CONCAT(spua.numero_ubicacion_desde, '-', altura_desde) ) AS product_location,
                        sd.cantidad_solicitada AS supply_quantity,
                        sd.cantidad_surtida AS supplied_quantity,
                        sd.id_asignado AS assigned_user_id,
                        sd.id_surtimiento_por_rango AS supply_range_id,
                        sd.creado_por AS seller_id
                    FROM ec_surtimiento_detalle sd
                    LEFT JOIN ec_productos p
                    ON sd.id_producto = p.id_productos
                    LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
                    ON p.id_productos = spua.id_producto
                    AND spua.id_sucursal = {$store_id}
                    WHERE sd.id_surtimiento_por_rango = {$supply_range_id}
                    AND ( sd.cantidad_surtida IS NULL 
                        OR ( sd.cantidad_solicitada > sd.cantidad_surtida AND sd.surtido_parcialmente = 0) 
                        OR ( sd.cantidad_surtida = 0 AND sd.no_se_surte = 0) 
                    )
                    AND sd.estado <= 3
                    AND spua.numero_ubicacion_desde >= {$current_location_number}
                    AND spua.altura_desde >= '{$current_location_letter}'
                    ORDER BY spua.numero_ubicacion_desde, spua.altura_desde, p.orden_lista ASC
                    LIMIT 1";//die($sql);
//error_log("PASO 2 getNextSupplydetail : {$sql}");/*AND Oscar aqui me quede. */
            $stm = $this->link->query($sql);
            if($stm->rowCount() <= 0){
//error_log("Entra en comprobacion de producto");
            //comprobacion
                $verification = $this->queryGetNExtProduct($supply_range_id, $user_id, $store_id, 0, "");
//error_log("Respuesta de verificacion : " . json_encode($verification));
                if(isset($verification['status']) && $verification['status']){
if($this->Logger){
    error_log("Entra en condicion para retornar SIN productos.");
}
                    die(json_encode(array("status"=>"no_products_found", "message"=>"No hay mas productos por surtir.")));
                }else{
if($this->Logger){
    error_log("Entra en condicion para retornar CON productos.");
}
                //cuando encuentra producto en la comprobacion
                    $verification['product_providers'] = array();
                    $verification['product_providers'] = $this->getProductsProviders($verification['product_id']);//obtiene proveedores producto
                    $supply_product = $verification;
                    $supply_product['counters'] = $supply_counters;
                }
            }else{
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                $row['product_providers'] = array();
                $row['product_providers'] = $this->getProductsProviders($row['product_id']);//obtiene proveedores producto
                $supply_product = $row;
                $supply_product['counters'] = $supply_counters;
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar siguiente producto por surtir.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        return json_encode($supply_product);
    }

    public function queryGetNExtProduct($supply_range_id, $user_id, $store_id, $current_location_number = 0, $current_location_letter = ""){
if($this->Logger){
    error_log("Entra en queryGetNExtProduct-2.");
}
/*Deshabilitado por Oscar 2025-07-14
    //Actualiza los registros que fueron surtidos paracialmente
        try{
            $sql = "UPDATE ec_surtimiento_detalle SET estado = 1
                    WHERE id IN(
                        SELECT
                            ax.id
                        FROM(
                            SELECT
                                id
                            FROM ec_surtimiento_detalle
                            WHERE sd.cantidad_solicitada > sd.cantidad_surtida 
                            AND sd.surtido_parcialmente = 0 
                        )ax
                    )";
            $link->query($sql);
        }catch(PDOException){
            die(json_encode(array("status"=>302, "message"=>"Error al actualizar registros por comprobacion.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
*/
        $supply_product = array();
        try{ 
            $sql = "SELECT
                        sd.id_surtimiento AS supply_id,
                        sd.id AS supply_detail_id,
                        p.id_productos AS product_id,
                        CONCAT('(', p.orden_lista, ') ', p.nombre)AS product_name,
                        UPPER( CONCAT(spua.numero_ubicacion_desde, '-', altura_desde) ) AS product_location,
                        sd.cantidad_solicitada AS supply_quantity,
                        sd.cantidad_surtida AS supplied_quantity,
                        sd.id_asignado AS assigned_user_id,
                        sd.id_surtimiento_por_rango AS supply_range_id,
                        sd.creado_por AS seller_id
                    FROM ec_surtimiento_detalle sd
                    LEFT JOIN ec_productos p
                    ON sd.id_producto = p.id_productos
                    LEFT JOIN ec_sucursal_producto_ubicacion_almacen spua
                    ON p.id_productos = spua.id_producto
                    AND spua.id_sucursal = {$store_id}
                    WHERE sd.id_surtimiento_por_rango = {$supply_range_id}
                    AND ( sd.cantidad_surtida IS NULL 
                        OR ( sd.cantidad_solicitada > sd.cantidad_surtida AND sd.surtido_parcialmente = 0 AND sd.no_se_surte = 0) 
                        OR ( sd.cantidad_surtida = 0 AND sd.no_se_surte = 0) 
                    )
                    AND sd.estado <= 4
                    AND spua.numero_ubicacion_desde >= {$current_location_number}
                    AND spua.altura_desde >= '{$current_location_letter}'
                    ORDER BY spua.numero_ubicacion_desde, spua.altura_desde, p.orden_lista ASC
                    LIMIT 1";//die($sql);
/*Teni sd.estado <= 3 y se cambia por sd.estado <= 4 para ver que vuelva a comprobar lo que ya se habia surtido y se edita para que vuelva a salir en la comprobacion*/
//error_log("Consulta productos por comprobacion : {$sql}");
            $stm = $this->link->query($sql);
            if($stm->rowCount() <= 0){
                $row2 = array();
        //consulta nombre del vendedor
                try{
                    $sql = "SELECT
                                CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) AS seller_name
                            FROM ec_surtimiento_por_rangos spr
                            LEFT JOIN ec_surtimiento s
                            ON spr.id_surtimiento = s.id
                            LEFT JOIN sys_users u
                            ON s.id_vendedor = u.id_usuario
                            WHERE spr.id_surtimiento_por_rango = {$supply_range_id}";
                    $stm2 = $this->link->query($sql);
                    $row2 = $stm2->fetch(PDO::FETCH_ASSOC);
                }catch(PDOException $error){
                    die(json_encode(array("status"=>"302", "message"=>"Error al consultar el nombre del vendedor.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
                }
//error_log("Entra en productos no encontrado en queryGetNExtProduct.");
                //return array("status"=>"no_products_found", "message"=>"No hay mas productos por surtir.");
                $range_is_finished = true;
                try{
                    $sql = "UPDATE ec_surtimiento_por_rangos SET id_status_surtimiento_pedidos = 4 WHERE id_surtimiento_por_rango = {$supply_range_id}";
//error_log("Actualiza el rango de surtimiento : {$sql}.");
                    $this->link->query($sql);
            //actualiza el status del rango            
                    $status_array = array();
                    $sql = "SELECT MIN(id_status_surtimiento_pedidos) AS min_status, id_surtimiento AS supply_id FROM ec_surtimiento_por_rangos WHERE id_surtimiento = (SELECT ax.id_surtimiento FROM(SELECT id_surtimiento FROM ec_surtimiento_por_rangos WHERE id_surtimiento_por_rango = {$supply_range_id} LIMIT 1)ax) LIMIT 1";//error_log($sql);
                    $stm_status = $this->link->query($sql);
                    $status_array = $stm_status->fetch(PDO::FETCH_ASSOC);
                    try{
                        $sql = "UPDATE ec_surtimiento SET estado = {$status_array['min_status']}, fecha_creacion = NOW(), fecha_modificacion = NOW() WHERE id = {$status_array['supply_id']}";//error_log($sql);
                        $this->link->query($sql);//error_log("Inserta surtimiento a pendiente de surtir: {$sql}");
                    }catch(PDOException $error){
                        die(json_encode(array("status"=>"302", "message"=>"Error al actualizar cabecera de surtimiento", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
                    }      
                }catch(PDOException $error){
                    $this->link->rollBack();
                    die(json_encode(array("status"=>"302", "message"=>"Error al actualizar el rango de surtimiento a terminado.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
                }
                if($range_is_finished == true){
                    die( json_encode(array("status"=>"200", "message"=>"Surtimiento Finalizado.", "seller_name"=>"{$row2['seller_name']}")) );//{$row['seller_name']}
                }
            }else{
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                $row['product_providers'] = array();
                $row['product_providers'] = $this->getProductsProviders($row['product_id']);//obtiene proveedores producto
                $supply_product = $row;
                //$supply_product['counters'] = $supply_counters;
            }
        }catch(PDOException $error){
//error_log("Error al consultar el siguiente producto : {$sql} : {$error->getMessage()}");
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar siguiente producto por surtir en comprobacion.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }
        return $supply_product;
    }

    public function getProductsProviders( $product_id ){
        //consulta url de api sqlite
        $sqlite_url_base = "";
        try{
            $sql = "SELECT `value` FROM `api_config` WHERE `key` = 'sqlite'";
            $stm = $this->link->query($sql);
            $row = $stm->fetch(PDO::FETCH_ASSOC);
            $sqlite_url_base = $row['value'];
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar la url base para interactuar con sqlite.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
        }

        $product_providers = array();
    //consume el servicio desde JSONServer
        $url = "{$sqlite_url_base}/ec_proveedor_producto/{$product_id}";//die("$url");//id_producto=
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        curl_close($ch);
        $p_p = json_decode($response, true);
        foreach ($p_p as $key => $p) {
            $tmp = array();
            $tmp['product_provider_id'] = $p['id'];
            $tmp['product_provider_model'] = $p['clave_proveedor'];
            $tmp['piece_barcode_1'] = $p['codigo_barras_pieza_1'];
            $tmp['piece_barcode_2'] = $p['codigo_barras_pieza_2'];
            $tmp['piece_barcode_3'] = $p['codigo_barras_pieza_3'];
            $tmp['pack_barcode_1'] = $p['codigo_barras_presentacion_cluces_1'];
            $tmp['pack_barcode_2'] = $p['codigo_barras_presentacion_cluces_2'];
            $tmp['box_barcode_1'] = $p['codigo_barras_caja_1'];
            $tmp['box_barcode_2'] = $p['codigo_barras_caja_2'];
            $tmp['supply_priority'] = $p['prioridad_surtimiento'];
            $product_providers[] = $tmp;
        }
        //print_r($data);
        return $product_providers;
    }

    public function exitSupply($supply_detail_id){
    //actualiza el surtimiento a pausa
        try{
            $sql = "UPDATE ec_surtimiento_detalle sd
                LEFT JOIN ec_surtimiento_por_rangos spr
                ON sd.id_surtimiento_por_rango = spr.id_surtimiento_por_rango
                    SET spr.id_status_surtimiento_pedidos = 3,
                        sd.estado = 3
                WHERE sd.id = {$supply_detail_id}
                AND sd.cantidad_surtida IS NULL";
            $this->link->query($sql);
        }catch(PDOException $error){
            die(json_encode(array("status"=>302, "message"=>"Error al pausar surtimiento.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
        }
        return json_encode(array("status"=>"200", "message"=>"Surtimiento pausado exitosamente."));
    }

    public function updateSupplyDetail($supply_detail_id, $quantity, $supply_range_id, $user_id, $store_id, $no_suplied, $partially_suplied, $current_location_number, $current_location_letter){
        $range_is_finished = false;
        $this->link->beginTransaction();
        $row = array();
        try{
            $sql = "UPDATE ec_surtimiento_detalle 
                        SET cantidad_surtida = ( IF(cantidad_surtida IS NULL, 0, cantidad_surtida ) + {$quantity} ), 
                        estado = 4, 
                        no_se_surte = '{$no_suplied}', 
                        surtido_parcialmente = '{$partially_suplied}'
                    WHERE id = {$supply_detail_id}";//IF(cantidad_surtida < cantidad_solicitada, 1, 0)
if($this->Logger){
    error_log("updateSupplyDetail PASO 1 : {$sql}");
}
            $this->link->query($sql);
            try{//IF(sd.estado <= 3, 1, 0)
                $sql = "SELECT
                            SUM(IF( sd.cantidad_surtida IS NULL OR ( sd.cantidad_solicitada != sd.cantidad_surtida AND (sd.no_se_surte = 0 OR sd.surtido_parcialmente = 0)), 1, 0 )) AS pending_details,
                            sd.id_surtimiento,
                            CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno ) AS seller_name
                        FROM ec_surtimiento_detalle sd
                        LEFT JOIN ec_surtimiento s
                        ON sd.id_surtimiento = s.id
                        LEFT JOIN sys_users u
                        ON s.id_vendedor = u.id_usuario
                        WHERE sd.id_surtimiento_por_rango = {$supply_range_id}";
if($this->Logger){
    error_log("updateSupplyDetail PASO 2 : {$sql}");
}
                $stm = $this->link->query($sql);
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                if($row['pending_details'] <= 0){
                    $range_is_finished = true;
                    try{
                        $sql = "UPDATE ec_surtimiento_por_rangos SET id_status_surtimiento_pedidos = 4 WHERE id_surtimiento_por_rango = {$supply_range_id}";
                        $this->link->query($sql);
                    }catch(PDOException $error){
                        $this->link->rollBack();
                        die(json_encode(array("status"=>302, "message"=>"Error al actualizar el rango de surtimiento a terminado.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
                    }
                }
            }catch(PDOException $error){
                $this->link->rollBack();
                die(json_encode(array("status"=>302, "message"=>"Error al consultar surtimientos pendientes.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
            }
        }catch(PDOException $error){
            $this->link->rollBack();
            die(json_encode(array("status"=>302, "message"=>"Error al actualizar detalle de surtimiento.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
        }
    //consulta si tiene mas rangos pendientes de surtir
        try{
            $sql = "SELECT
                        COUNT(*) AS pending_ranges
                    FROM ec_surtimiento_por_rangos
                    WHERE id_surtimiento = {$row['id_surtimiento']}
                    AND id_status_surtimiento_pedidos <= 3";
            $stm2 = $this->link->query($sql);
            $row2 = $stm2->fetch(PDO::FETCH_ASSOC);
            if($row2['pending_ranges'] <= 0){//marca surtimiento como finalizado si ya no hay rangos por surtir
                try{
                    $sql = "UPDATE ec_surtimiento SET estado = 4 WHERE id = {$row['id_surtimiento']}";
                    $this->link->query($sql);
                }catch(PDOException $error){
                    $this->link->rollBack();
                    die(json_encode(array("status"=>302, "message"=>"Error al consultar rangos de surtimiento pendientes.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
                }
            }
        }catch(PDOException $error){
            $this->link->rollBack();
            die(json_encode(array("status"=>302, "message"=>"Error al consultar rangos de surtimiento pendientes.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
        }
        $this->link->commit();
        if($range_is_finished == true){
            return json_encode(array("status"=>"200", "message"=>"Surtimiento Finalizado.", "seller_name"=>"{$row['seller_name']}"));
        }
        return $this->getNextSupplyDetail($supply_range_id, $user_id, $store_id, $current_location_number, $current_location_letter);
    }

    public function printFinishedTicket($supply_range_id, $store_id, $user_id, $rootpath, $user_tipo_sistema){
        include("printFinishedSupplyTicket.php");
        return json_encode(array("status"=>"200", "message"=>"Ticket generado exitosamente."));
    }

    public function printPausedTicket($supply_range_id, $store_id, $user_id, $rootpath, $user_tipo_sistema){
        include("printPausedSupplyTicket.php");
        return json_encode(array("status"=>"200", "message"=>"Ticket generado exitosamente."));
    }

/*
    Oscar 2025-06-19
*/
    public function checkAccess( $user_id ){
        $es_cajero = null;
        $max_execution_time = null;
        $system_type = null;
        $stm = null;
        $user = null;
        try{
            $sql="SELECT 
                    IF(p.ver=1 OR p.modificar=1,1,0),
                    ( SELECT id_sucursal FROM sys_sucursales WHERE acceso = 1 LIMIT 1 ) AS system_type,
                    ( SELECT tiempo_espera_respuesta_websocket FROM ec_configuracion_sucursal WHERE id_sucursal = {$this->store_id} ) AS max_execution_time/*1.2 tiempo espera dinamico 2024-07-04*/
                FROM sys_permisos p
                LEFT JOIN sys_users_perfiles perf ON perf.id_perfil=p.id_perfil
                LEFT JOIN sys_users u ON u.tipo_perfil=perf.id_perfil 
                WHERE p.id_menu = 312
                AND u.id_usuario={$user_id}";
            $stm = $this->link->query( $sql );
            //$es_cajero=mysql_fetch_row($eje);
            $es_cajero = $stm->fetch(PDO::FETCH_NUM);//->fetch_row();
            $max_execution_time = $es_cajero[2];/*1.2 tiempo espera dinamico 2024-07-04*/
            $system_type = $es_cajero[1];//tipo de sistema
            if($es_cajero[0] == 0 ){
                die('<script>alert("Este tipo de usuario no puede acceder a esta pantalla.\nContacta al administrador desl sistema.");location.href="../../../../index.php?";</script>');
            }
        }catch(PDOException $error){
            die("Error al consultar el permiso de cajero : {$sql} : {$error}");
        }
    //consulta si tiene token activo
        try{
            $sql = "SELECT token FROM api_token WHERE id_user = {$user_id} ";// AND expired_in > NOW()AND expired_in > NOW()
            $stm = $this->link->query( $sql );
        }catch(PDOException $error){
            die( "Error al consultar si hay token activo para pantalla de cobros : {$sql} : {$error}" );
        }
        if( $stm->rowCount() <= 0 ){//num_rows
        //obtiene el password del usuario
            try{
                $sql = "SELECT 
                            id_usuario AS user_id, 
                            login, 
                            contrasena AS password,
                            ( SELECT `value` FROM api_config WHERE `key` = 'api' ) AS api_path 
                        FROM sys_users WHERE id_usuario = '{$user_id}'";
                $stm2 = $this->link->query( $sql );
                $user = $stm2->fetch(PDO::FETCH_ASSOC);//fetch_assoc();
            }catch(PDOException $error){
                die( "Error al consultar datos de usuario : {$sql} : {$error}" );
            }
        //consume servcio para obtener token
            $post_data = json_encode( array( "user"=>"{$user['login']}", "password"=>"{$user['password']}" ) );
            $result = json_decode( $this->sendPetition( "{$user['api_path']}/rest_v2/netPay/token", $post_data ) );
            //var_dump($result);
            if( !isset($result->status)  ){//|| $result->status != "OK" || $result->status != "OK"
                die("Error al generar el token para pantalla de cobros : {$result->description}");
            }else{
                //var_dump( $result->result->created_in );die('');
            //inserta el token en la tabla api_token
                if( $system_type > 0 ){
                //elimina tokens que ya no estan activos para el usuario
                    try{
                        $sql = "DELETE FROM api_token WHERE id_user = {$user_id} AND expired_in <= NOW()";
                        $this->link->query($sql);
                    }catch(PDOException $error){
                        die( json_encode( array("status"=>"303", "message"=>"Error al insertar token en cliente", "query"=>"{$sql}", "error_detail"=>"{$error}")));
                    }
                    try{
                        $sql = "INSERT INTO api_token ( id_user, token, created_in, expired_in ) 
                            VALUES ( {$user_id}, '{$result->result->access_token}', 
                            '{$result->result->created_in}', '{$result->result->expired_in}' )";	//die( $sql );			
                        $stm3 = $this->link->query( $sql );
                    }catch(PDOException $error){
                        die( "Error al insertar token en cliente : {$sql} : {$error}" );
                    }
                }
            }
            return array( "status"=>200, "token"=>$result->result->access_token, "max_execution_time"=>$max_execution_time );/*1.2 tiempo espera dinamico 2024-07-04*/
        }else{
            $row = $stm->fetch(PDO::FETCH_ASSOC);//fetch_assoc();
        //validacion / renovacion de token
            $post_data = null;
        //actualiza la caducidad del token en local
            try{
               return array( "status"=>200, "token"=>$row['token'], "max_execution_time"=>$max_execution_time  );//1.2 tiempo espera dinamico 2024-07-04
            }catch(Exception $error){
                return "Error : {$error->getMessage()}";
            }
        }
    }
    public function updateRangeSuppyStatus($supply_range_id, $status){
        $current_status = null;
        try{
            $sql = "SELECT 
                        id_status_surtimiento_pedidos AS range_status
                    FROM ec_surtimiento_por_rangos
                    WHERE id_surtimiento_por_rango = {$supply_range_id}";//die($sql);
            $stm = $this->link->query($sql);
            $row = $stm->fetch(PDO::FETCH_ASSOC);
            $current_status = $row['range_status'];
            if(($current_status == 5 || $current_status == 4) && $status == 3){
                die(json_encode(array("status"=>"301", "message"=>"NO se puede pausar un surtimiento finalizado o cancelado.")));
            }else{
                try{
                    $sql = "UPDATE ec_surtimiento_por_rangos
                                SET id_status_surtimiento_pedidos = {$status}
                            WHERE id_surtimiento_por_rango = {$supply_range_id}";
                    $this->link->query($sql);
                    die(json_encode(array("status"=>"200", "message"=>"Surtimiento Actualizado exitosamente.")));
                }catch(PDOException $error){
                    die(json_encode(array("status"=>302, "message"=>"Error al actualizar status de rango de surtimiento.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
                }
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>302, "message"=>"Error al consultar status actual del rango de surtimiento.", "query"=>$sql, "error_detail"=>"{$error->getMessage()}")));
        }
        
    }
//peticion curl
    public function sendPetition( $url, $post_data, $token = '' ){
        //die( $url );
        $resp = "";
        $crl = curl_init( $url );
        curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($crl, CURLINFO_HEADER_OUT, true);
        curl_setopt($crl, CURLOPT_POST, true);
        curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
        //curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
        curl_setopt($crl, CURLOPT_TIMEOUT, 60000);
        curl_setopt($crl, CURLOPT_HTTPHEADER, array(
          'Content-Type: application/json',
          'token: ' . "{$token}" )
        );
        $resp = curl_exec($crl);//envia peticion
        curl_close($crl);
        return $resp;
    }
}
?>
