<?php
	define('FPDF_FONTPATH','../../../../include/fpdf186/font/');
	include("../../../../include/fpdf186/fpdf.php");
//include '../../../../conect.php';
//$supply_range_id = $_GET['id'];
//consulta informacion de vendedor y surtidor
    $supply_header = array();
    $supply_detail_ok = array();
    $total_size = 90;
//consulta datos de cabecera
	try{
		$sql="SELECT
                s.id AS supply_id,
                CONCAT(u1.nombre, ' ', u1.apellido_paterno, ' ', u1.apellido_materno) AS seller_name,
                CONCAT(u2.nombre, ' ', u2.apellido_paterno, ' ', u2.apellido_materno) AS suplier_name,
                suc.nombre AS store_name
            FROM ec_surtimiento s
            LEFT JOIN ec_surtimiento_por_rangos spr
            ON s.id = spr.id_surtimiento
            LEFT JOIN sys_users u1
            ON s.id_vendedor = u1.id_usuario
            LEFT JOIN sys_users u2
            ON spr.id_usuario_asignado = u2.id_usuario
            LEFT JOIN sys_sucursales suc
            ON s.id_sucursal = suc.id_sucursal
            WHERE spr.id_surtimiento_por_rango = {$supply_range_id}";
		$stm = $this->link->query($sql);
		$supply_header = $stm->fetch(PDO::FETCH_ASSOC);
	}catch(PDOException $error){
		die(json_encode(array("status"=>"302", "message"=>"Error al consultar datos de vendedor y surtidor.", "query"=>"{$sql}", "message_detail"=>"{$error->getMessage()}")));
	}
//consulta detalles del rango
	try{
		$sql="SELECT
                p.orden_lista AS product_list_order,
                p.nombre As product_name,
                sd.cantidad_surtida AS suplied_quantity
            FROM ec_surtimiento_detalle sd
            LEFT JOIN ec_productos p
            ON p.id_productos = sd.id_producto
            WHERE sd.id_surtimiento = {$supply_header['supply_id']}
            AND sd.id_surtimiento_por_rango = {$supply_range_id}
            AND sd.cantidad_surtida IS NOT NULL";
		foreach($this->link->query($sql) as $row){
            $row['product_name'] = part_word($row['product_name']);
            $supply_detail_ok[] = $row;
            $total_size += 12;
        }
	}catch(PDOException $error){
		die(json_encode(array("status"=>"302", "message"=>"Error al consultar datos de productos surtidos.", "query"=>"{$sql}", "message_detail"=>"{$error->getMessage()}")));
	}
    
//extraccion de rutas de tickets
    $archivo_path = "../../../../conexion_inicial.txt";
	$carpeta_path = "";
    if(file_exists($archivo_path)){
        $file = fopen($archivo_path,"r");
        $line=fgets($file);
        fclose($file);
        $config=explode("<>",$line);
        $tmp=explode("~",$config[2]);
        $ruta_or=$tmp[0];
        $ruta_des=$tmp[1];
	    $tmp_=explode("~",$config[0]);
		$carpeta_path = base64_decode( $tmp_[1] );
    }else{
        die(json_encode(array("status"=>"", "message"=>"No hay archivo de configuración.")));
    }
    
	class TicketPDF extends FPDF {
		// Members
		var $sucursal = "";
		var $pedido = "";
		var $inicio = 32;
	
		// Constructor
		function TicketPDF($orientation='P', $unit='mm', $size = 0, $sucursal='', $pedido='', $inicio=10) {
			parent::FPDF($orientation, $unit, $size);
				
			$this->AddFont('Arial');
			$this->SetMargins(6, 0, 6);
			$this->SetDisplayMode("real", "continuous");
			#$this->SetAutoPageBreak(false);
			$this->SetAutoPageBreak(true, -5);
				
			$this->sucursal = mb_convert_encoding($sucursal, 'ISO-8859-1', 'UTF-8');//utf8_decode($sucursal);
			$this->pedido = mb_convert_encoding($pedido, 'ISO-8859-1', 'UTF-8');//utf8_decode($pedido);
			$this->inicio = $inicio;
		}
	
		// Cabecera de página
		function Header() {
		}
	
		function Footer() {
			//$this->SetY(-15);
			//$this->SetFont('Arial','I',8);
			// Número de página
			//$this->Cell(0,10, utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
		}
	
		function AcceptPageBreak() {
			$x = $this->GetX();
			$this->AddPage();
			//$this->SetXY($x, $this->inicio);
			$this->SetXY($x, 1);
			#$this->SetY($this->inicio);
			return false;
		}
	}
    $total_size = ($total_size <= 90 ? 90 : $total_size);
    $sizes = array(80, ($total_size));
	$ticket = new TicketPDF("P", "mm", $sizes , "sucursal", "folio", 10);
	//echo 'res:'.$resAprox;
	$ticket->AliasNbPages();
	$ticket->AddPage();
	
	$bF=10;
//encabezado
	$ticket->SetFont('Arial','B',$bF+6);
	$ticket->SetXY(5, 5);//$ticket->GetY()+3
	$ticket->Cell(70, 6, mb_convert_encoding("Surtimiento #{$supply_header['supply_id']}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");//utf8_decode("Folio: ".$folio_sesion_caja)

	$ticket->SetFont('Arial','B',$bF+6);
	$ticket->SetXY(5, $ticket->GetY()+8);//
	$ticket->Cell(70, 6, mb_convert_encoding("Pausado", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");//utf8_decode("Folio: ".$folio_sesion_caja)

    
	$ticket->SetFont('Arial','B',$bF+2);
	$ticket->SetXY(5, $ticket->GetY()+10);
	$ticket->Cell(70, 6, mb_convert_encoding("Vendedor:", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");

	$ticket->SetFont('Arial','B',$bF+3);
    $ticket->SetXY(5, $ticket->GetY()+6);
	$ticket->Cell(70, 6, mb_convert_encoding("{$supply_header['seller_name']}", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");
	
	$ticket->SetFont('Arial','B',$bF+2);
	$ticket->SetXY(5, $ticket->GetY()+10);
	$ticket->Cell(70, 6, mb_convert_encoding("Surtidor Anterior:", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");

	$ticket->SetFont('Arial','B',$bF+3);
    $ticket->SetXY(5, $ticket->GetY()+6);
	$ticket->Cell(70, 6, mb_convert_encoding("{$supply_header['suplier_name']}", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");
//surtimientos exitosos
    if(sizeof($supply_detail_ok) > 0){
        $ticket->SetFont('Arial','B',$bF);
        $ticket->SetXY(5, $ticket->GetY()+10);
        $ticket->Cell(70, 6, mb_convert_encoding("Productos ya surtidos:", 'ISO-8859-1', 'UTF-8'), "0" ,0, "L");

        $ticket->SetFont('Arial','B',$bF-2);
        foreach ($supply_detail_ok as $key => $row) {
            $ticket->SetXY(5, $ticket->GetY()+6);
            $ticket->Cell(10, 6, mb_convert_encoding("{$row['product_list_order']}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
            $ticket->SetXY(70, $ticket->GetY());
            $ticket->Cell(5, 6, mb_convert_encoding("{$row['suplied_quantity']}", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
            foreach($row['product_name'] as $key => $name) {
                $ticket->SetXY(15, $ticket->GetY() + ($key > 0 ? 5 : 0));
                $ticket->Cell(55, 6, mb_convert_encoding("{$name}", 'ISO-8859-1', 'UTF-8'), "" ,0, "L");
            }
        }
    }
	
//Ruta especifica de ticket
	/*instancia clases*/
	include( '../../controladores/SysArchivosDescarga.php' );
	$SysArchivosDescarga = new SysArchivosDescarga( $this->link );
	include( '../../controladores/SysModulosImpresionUsuarios.php' );
	$SysModulosImpresionUsuarios = new SysModulosImpresionUsuarios( $this->link );
	include( '../../controladores/SysModulosImpresion.php' );
	$SysModulosImpresion = new SysModulosImpresion( $this->link );

	$nombre_ticket="ticket_".$store_id."_supply_paused_".date("YmdHis").".pdf";
	$ruta_salida = '';
	$ruta_salida = $SysModulosImpresionUsuarios->obtener_ruta_modulo_usuario( $user_id, 17, $rootpath );//cotizacion de ventas
	if( $ruta_salida == 'no' ){
		$ruta_salida = "cache/" . $SysModulosImpresion->obtener_ruta_modulo( $store_id, 17, $rootpath );//cotizacion de ventas
	}
	$ticket->Output( "../../../../{$ruta_salida}/{$nombre_ticket}", "F" );
/*Sincronización remota de tickets*/
	if( $user_tipo_sistema == 'linea' ){/*registro sincronizacion impresion remota*/
		$registro_sincronizacion = $SysArchivosDescarga->crea_registros_sincronizacion_archivo( 17, 'pdf', $nombre_ticket, $ruta_or, $ruta_salida, $store_id, $user_id, true );
	}else{//impresion por red local
		$enviar_por_red = $SysArchivosDescarga->crea_registros_sincronizacion_archivo_por_red_local( 17, 'pdf', $nombre_ticket, '', $ruta_salida, $store_id, $user_id, $carpeta_path );
	}
    
    function part_word( $txt ){
        $size = strlen( $txt );
        $half = round( $size / 2 );
        $words = explode(' ', $txt );
        $resp = array( '','');
        $chars_counter = 0;
        $middle_word = "";
        foreach ($words as $key => $word) {
            $is_middle = 0;
            if( $key > 0 ){
                $chars_counter ++;//espacio
                if( $chars_counter == $half ){
                    $is_middle = 1;
                }
            }
            for( $i = 0; $i < strlen( $word ); $i ++ ){
                $chars_counter ++;//palabras
                if( $chars_counter == $half || $is_middle == 1){
                    $middle_word = $word;
                    $is_middle = 1;
                }
            }
            if( $middle_word == '' ){
                $resp[0] .= ( $resp[0] != '' ? ' ' : '' );
                $resp[0] .= $word;
            }else if( $middle_word != '' && $is_middle == 0 ){
                $resp[1] .= ( $resp[1] != '' ? ' ' : '' );
                $resp[1] .= $word;
            }
            $is_middle = 0;
        }
        if( strlen( "{$resp[0]} {$middle_word}" ) < strlen( "{$middle_word} {$resp[1]}" )  ){//asigna palabra intermedia a primera parte
            $resp[0] = "{$resp[0]} {$middle_word}";
        }else{//asigna palabra intermedia a segunda parte
            $resp[1] = "{$middle_word} {$resp[1]}";
        }
        return $resp;
    }
?>