<?php

use GuzzleHttp\Psr7\Query;
// Manejo de la solicitud POST
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    //require_once '../../../../rest/src/config/db.php';
    require_once '../../../../conectMin.php';
    $administracionSurtimiento = new administracionSurtimiento($link, $sucursal_id);
    $action = isset($_POST['action']) ? $_POST['action'] : '';
//obtener lista de surtimientos
    switch($action){
    //obtener detalle del rengo de surtimiento
        case 'getSupplyRangeAssignation' :
            $supply_range_id = (isset($_POST['supply_range_id']) ? $_POST['supply_range_id'] : $_GET['supply_range_id']);
            $list = $administracionSurtimiento->getSupplyRangeAssignation($supply_range_id, $sucursal_id);
            echo (json_encode($list));
        break;
    //
        case 'updateAllSupplyStatus' :
            $supply_id = (isset($_POST['supply_id']) ? $_POST['supply_id'] : $_GET['supply_id']);
            $status = (isset($_POST['status']) ? $_POST['status'] : $_GET['status']);
            echo $administracionSurtimiento->updateAllSupplyStatus($supply_id, $status);
        break;
    //caso default
        default:
            echo "Permission denied on '{$action}'.";
        break;
    }
}

class administracionSurtimiento {
    private $link;
    private $store_id;

    public function __construct($connection, $store_id) {
        $this->link = $connection;
        $this->store_id = $store_id;
    }

    public function getSupplyRangeAssignation($supply_range_id, $store_id){
        $supply_range_detail = array();
        $range_row = null;
    //consulta informacion del rango y surtimiento
        try{
            $sql = "SELECT
                        spr.id_status_surtimiento_pedidos AS status_id
                FROM ec_surtimiento_por_rangos spr
                LEFT JOIN ec_surtimiento s
                ON spr.id_surtimiento = s.id
                WHERE spr.id_surtimiento_por_rango = {$supply_range_id}";
            $stm = $this->link->query($sql);
            $range_row = $stm->fetch(PDO::FETCH_ASSOC);
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar datos de rango de surtimiento.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}" )));
        }
        try{
            $sql = "SELECT
                        p.orden_lista AS product_list_order,
                        p.nombre AS product_name,
                        sd.cantidad_solicitada AS solicited_quantity,
                        sd.cantidad_surtida AS suplied_quantity,
                        CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) AS supplier_name
                    FROM ec_surtimiento_detalle sd
                    LEFT JOIN ec_productos p
                    ON p.id_productos = sd.id_producto
                    LEFT JOIN sys_users u
                    ON u.id_usuario = sd.id_asignado
                    WHERE sd.id_surtimiento_por_rango = {$supply_range_id}";
            foreach($this->link->query($sql) as $row){
                $supply_range_detail[] = $row;
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar datos de rango de surtimiento.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}" )));
        }
        return array("supply_range_id"=>"{$supply_range_id}", "supply_status_id"=>"{$range_row['status_id']}", "detail"=>$supply_range_detail);
    }

    public function updateAllSupplyStatus($supply_id, $new_status){
        $change_supply_date = 'false';
    //consulta si el pedido es del dia actual
        try{
            $sql = "SELECT
                        DATE(fecha_creacion) AS supply_date,
                        DATE(NOW()) AS current_date_
                    FROM ec_surtimiento
                    WHERE id = {$supply_id}";
            $stm = $this->link->query($sql);
            $row = $stm->fetch(PDO::FETCH_ASSOC);
            if($row['supply_date'] != $row['supply_date'] && $new_status == 1){
                $change_supply_date = 'true';
            }
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al consultar fecha del pedido.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}" )));
        }
        try{
            $sql = "UPDATE ec_surtimiento_detalle sd
                    INNER JOIN ec_surtimiento_por_rangos spr
                    ON sd.id_surtimiento = spr.id_surtimiento
                    INNER JOIN ec_surtimiento s
                    ON s.id = spr.id_surtimiento
                        SET sd.estado = {$new_status},
                        sd.fecha_creacion = IF('{$change_supply_date}' = 'true', NOW(), sd.fecha_creacion),
                        sd.fecha_modificacion = IF('{$change_supply_date}' = 'true', NOW(), sd.fecha_modificacion),
                        spr.id_status_surtimiento_pedidos = {$new_status},
                        spr.fecha_alta = IF('{$change_supply_date}' = 'true', NOW(), spr.fecha_alta),
                        s.estado = {$new_status},
                        s.fecha_creacion = IF('{$change_supply_date}' = 'true', NOW(), s.fecha_creacion),
                        s.fecha_modificacion = IF('{$change_supply_date}' = 'true', NOW(), s.fecha_modificacion)
                    WHERE s.id = {$supply_id}";
            $this->link->query($sql);
        }catch(PDOException $error){
            die(json_encode(array("status"=>"302", "message"=>"Error al actualizar el status de todo el surtimiento.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}" )));
        }
        return json_encode(array("status"=>"200", "message"=>"Status de pedido actualizado exitosamente."));
    }
    /*public function getLogedUsers($store_id){
        try{

        }catch(PDOException $error){

        }
    }*/
}
?>
