<?php
    final class apiGetNet{
        private $link;
        private $Logger;
        private $url = array();
        public function __construct($connection) {
            $this->link = $connection;
            $this->Logger = $this->getLogConfig();
        }
        //consulta url de getnet
        function getLogConfig(){
            try{
                $sql = "SELECT habilitar_log FROM sys_logs_archivos WHERE id_log_archivo = 5";
                $stm = $this->link->query($sql);
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                return ($row['habilitar_log'] == 1 || $row['habilitar_log'] == '1' ? true : false);
            }catch(PDOException $error){
                die(json_encode(array("status"=>"302", "message"=>"Error al consultar status de log del archivo.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
            }
        }

        function sendGetNetPetition($store_id, $user_id, $terminal_serial_number, $sale_folio){
            $api_path = null;
            $system_type = null;
        //consulta url de api sistema general linea
            try{
                $sql = "SELECT 
                            `value` AS api_path,
                            (SELECT id_sucursal FROM sys_sucursales WHERE acceso = 1) AS store_id
                        FROM api_config WHERE `key` = 'api'";
                $stm = $this->link->query($sql);
                $row = $stm->fetch(PDO::FETCH_ASSOC);
                $api_path = $row['api_path'];
                $system_type = $row['store_id'];
if($this->Logger){
    error_log("Consulta la url del api sistema general linea : \n {$sql}");
}
            }catch(PDOException $error){
                $json_error = json_encode(array("status"=>"302", "message"=>"Error al consultar path de API.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}"));
if($this->Logger){
    error_log($json_error);
}
                die($json_error);
            }
        //forma datos de peticion
            $data = array();
            $data['store_id'] = $store_id;
            $data['user_id'] = $user_id;
            $data['terminal_serial_number'] = $terminal_serial_number;
            $data['sale_folio'] = $sale_folio;
            $data['system_type'] = $system_type;
            $post_data = json_encode($data);
        //envia peticion
            $resp = $this->sendPetition("{$api_path}/rest_v2/getNet/inserta_registro_peticion", $post_data, '');
//echo "here 1 : {$resp}";
            $resp_json = json_decode($resp, true);
            if(isset($resp_json['status']) && ( $resp_json['status'] == 200 || $resp['status'] == '200')){
            //inserta la peticion en local
                $sql = "INSERT INTO `gt_transacciones_getnet`(`gt_folio_unico`, `gt_folio_venta`, `gt_id_sucursal`, gt_id_tipo_sistema, `gt_id_cajero`, `gt_id_sesion_caja`) 
                        VALUES ('{$resp_json['unique_folio']}', '{$sale_folio}', {$store_id}, {$system_type}, {$user_id})";
                $this->link->query($sql);
                return $resp_json['unique_folio'];//$resp_json['status'];
            }
        }

        public function salePetition($apiUrl, $store_id, $user_id, $ammount, $serial_number, $sale_folio, $license){
            $unique_folio = $this->sendGetNetPetition($store_id, $user_id, $serial_number, $sale_folio);
//echo "folio_unico : {$unique_folio}";
        //forma peticion
            $data = array();
            $data['TrxCurrency'] = '1';
            $data['TrxDevice'] = "{$serial_number}";//WPYB002515027838
            $data['TrxAmount'] = $ammount;
            $data['TrxReference'] = "{$unique_folio}";//
            $data['TrxAuth'] = '082244';
            /*$data['TrxFValue'] = "{$store_id}";*/
            $data['TrxUser'] = "{$user_id}";
            $data['License'] = "{$license}";
            $post_data = json_encode($data, JSON_PRETTY_PRINT);
            //$url = $this->url;
            $resp = $this->sendPetition($apiUrl, $post_data, $license);
            return $resp;
        }
        public function cancelPetition(){
        //consulta url de getnet
                
        }


		public function getEndpoint( $terminal_id, $endpoint_type, $log_id = null ){
            if($this->Logger){
            error_log("Entra en getEndpoint( {$terminal_id}, {$endpoint_type}, {$log_id} );");
            }
            $steep_log_id = 0;
            try{
                $sql = "SELECT 
                            {$endpoint_type} AS endpoint
                        FROM ec_terminales_integracion_smartaccounts tis 
                        LEFT JOIN ec_tipos_bancos tb
                        ON tis.id_tipo_terminal = tb.id_tipo_banco
                        WHERE tis.id_terminal_integracion = '{$terminal_id}'
                        OR tis.numero_serie_terminal = '{$terminal_id}'";//die( $sql );
                $stm = $this->link->query( $sql );

            /*if( $log_id != null ){
            $steep_log_id = $this->Logger->insertLoggerSteepRow( $log_id, "Consulta el endpoint de la integracion SmartAccounts", $sql );
            }*/
                $row = $stm->fetch(PDO::FETCH_ASSOC);//fetch_assoc();/*Logger*/
if($this->Logger){
error_log("Consulta el endpoint de la integracion SmartAccounts : {$sql}");
error_log("Resultado : {$row['endpoint']}");
}
                return $row['endpoint'];
            }catch(PDOException $error){
                if( $log_id != null ){
                    $steep_log_error = $this->Logger->insertErrorSteepRow( $steep_log_id, 'ec_terminales_integracion_smartaccounts', 'N/A', $sql, $this->link->error );
                }
                die( "Error al consultar endpoint {$endpoint_type} : {$this->link->error}" );
            }
        }

        function sendPetition($url, $post_data, $license){
            $crl = curl_init( "{$url}" );
            curl_setopt($crl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($crl, CURLINFO_HEADER_OUT, true);
            curl_setopt($crl, CURLOPT_POST, true);
            curl_setopt($crl, CURLOPT_POSTFIELDS, $post_data);
            curl_setopt($crl, CURLOPT_TIMEOUT, 10);
            curl_setopt($crl, CURLOPT_USERAGENT, 'PostmanRuntime/7.32.2');

            curl_setopt($crl, CURLOPT_HTTPHEADER, [
                "Authorization: Bearer {$license}",
                'Content-Type: application/json',
                "Content-Length: " . strlen($post_data)
            ]);
            $resp_curl = curl_exec($crl);//envia peticion
            //var_dump($resp_curl);
            curl_close($crl);
            return $resp_curl;
        }
        
    }
    
?>