    current_product_provider_id = null;
    current_warehouse = null;
    current_date_since = null;
    current_date_to = null;
    function productProviderSeeker(e){
        if(e.keyCode != 13 && e != 'intro'){
            return false;
        }
        var txt = $("#product_provider_seeker").val().trim();
        if(txt.length <= 0){
            alert("El buscador no puede ir vacio.");
            return false;
        }
        var url = `ajax/graficaProveedorProducto.php?action=productProviderSeeker&txt=${txt}`;
        var resp = ajaxR(url);
        $('#product_provider_seeker_response').html(resp);
        $('#product_provider_seeker_response').css("display", "block");

    }

    function setProductProvider(product_provider_id, name){
        current_product_provider_id = product_provider_id;
        $("#product_provider_seeker").val(name);
        $("#product_provider_seeker").attr("disabled", true);

        $('#product_provider_seeker_response').html("");
        $('#product_provider_seeker_response').css("display", "none");

        $("#seeker_btn_search").addClass("hidden");
        $("#seeker_btn_reset").removeClass("hidden");
    }

    function getGrafic(){
        if(current_product_provider_id == null){
            alert("Primero selecciona un proveedor producto.");
            return false;
        }
        current_warehouse = $('#warehouse_id').val();
        if(current_warehouse == '' || current_warehouse == null){
            alert("Primero selecciona una almacen.");
            return false;
        }
        current_date_since = $('#date_since').val();
        if(current_date_since == '' || current_date_since == null){
            alert("Primero selecciona una fecha desde.");
            return false;
        }
        current_date_to = $('#date_to').val();
        if(current_date_to == '' || current_date_to == null){
            alert("Primero selecciona una fecha hasta.");
            return false;
        }
        var url = `ajax/graficaProveedorProducto.php?action=getProductProviderGrafic&product_provider=${current_product_provider_id}&warehouse=${current_warehouse}&date_since=${current_date_since}&date_to=${current_date_to}`;
        var resp = ajaxR(url);
        console.log(resp);
        var resp_json = JSON.parse(resp);
        console.log(resp_json);
        buildGrafic(resp_json);
        buildTable(resp_json);
    }
    
    function buildGrafic(dinamic_values){
        $('#linea').highcharts({
            chart: {
                type: 'line',  // tipo de gráfica
                borderWidth: 0 // ancho del borde de la gráfica
            },
            title: {
                text: 'Desgloce Movimientos', // título
                x: -20 
            },
            subtitle: {
                text: 'Proveedor-Producto', // subtítulo
                x: -20
            },
            xAxis: {
                categories: dinamic_values[0].data // categorías
            },
            yAxis: {
                title: {
                    text: 'Piezas' // nombre del eje de Y
                },
                plotLines: [{
                    color: '#808080'
                }]
            },
            tooltip: {
                valueSuffix: ' Piezas' // el sufijo de la información presente en el "tooltip"
            },
            legend: { // configuración de la leyenda
                layout: 'horizontal',
                align: 'center',
                verticalAlign: 'bottom',
                borderWidth: 1
            },
            series: dinamic_values
        });
    }

    function buildTable(dinamic_data){
        var content = `<table class="table table-bordered table-striped" id="detail_table">
            <thead>
                <tr>
                    <th class="text-center">Fecha</th>
                    <th class="text-center">Movimientos</th>
                    <th class="text-center">Inventario</th>
                </tr>
            </thead>
            <tbody>`;
        for (const key in dinamic_data[0].data) {
            content += `<tr>
                <td class="text-center">${dinamic_data[0].data[key]}</td>
                <td class="text-center">${dinamic_data[1].data[key]}</td>
                <td class="text-center">${dinamic_data[2].data[key]}</td>
            </tr>`;
        }
        content += `</tbody>`;
        $('#table_container').html(content);
    }

    function export_csv(){
        var data_export = `FECHA,MOVIMIENTOS,INVENTARIO`;
        $('#detail_table tr').each(function(index){
            if(index > 0){
                $(this).children('td').each(function(index2){
                    data_export += (index2 == 0 ? `\n` : ``);
                    data_export += $(this).html().trim() + (index2 <=1 ? `,` : ``);
                });
            }
        });
        //alert(data_export);
        exportToCSV('exportacion_detalle.csv', data_export);
    }

    function exportToCSV(filename, rows) {
        const csvContent = rows;//rows.map(row => row.join(",")).join("\n");
        const encodedUri = encodeURI('data:text/csv;charset=utf-8,' + csvContent);
        const link = document.createElement("a");
        link.setAttribute("href", encodedUri);
        link.setAttribute("download", filename);
        document.body.appendChild(link);  // Necesario para Firefox
        link.click();
        document.body.removeChild(link);  // Limpiar después de la descarga
    }

    function resetProduct(){
        current_product_provider_id = null;
        current_warehouse = null;
        current_date_since = null;
        current_date_to = null;
        $('#table_container').html("");
        $('#linea').html("");
        $("#product_provider_seeker").val("");
        $("#product_provider_seeker").removeAttr("disabled");
        $("#seeker_btn_reset").addClass("hidden");
        $("#seeker_btn_search").removeClass("hidden");
        $("#product_provider_seeker").focus();
seeker_btn_reset
    }

    function ajaxR(url){
		if(window.ActiveXObject){		
			var httpObj = new ActiveXObject("Microsoft.XMLHTTP");
		}
		else if (window.XMLHttpRequest){		
			var httpObj = new XMLHttpRequest();	
		}
		httpObj.open("POST", url , false, "", "");
		httpObj.send(null);
		return httpObj.responseText;
	}