<?php
    include('../../../../../conectMin.php');
    include('ajax/graficaProveedorProducto.php');
    $graficaProveedorProducto = new graficaProveedorProducto($link);
    $titulo_grafica = "graf";
?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>Grafica proveedor producto</title>
        <link rel="stylesheet" href="../../../../../css/bootstrap/css/bootstrap.css">
        <link rel="stylesheet" href="../../../../../css/icons/css/fontello.css">
        <script src="../../../../../js/jquery-1.10.2.min.js"></script>
        <script src="../../../../../js/Highcharts-7.0.3/code/highcharts.js"></script>
        <script src="../../../../../js/Highcharts-7.0.3/code/modules/series-label.js"></script>
        <script src="../../../../../js/Highcharts-7.0.3/code/modules/exporting.js"></script>
        <script src="js/functions.js"></script>
	</head>
	<body>
        <div class="row header bg-info p-1">
            <div class="col-5 text-center">
                <label for="date_since" class="text-light">Buscar Proveedor Producto</label>
                <div class="input-group">
                    <input type="text" id="product_provider_seeker" class="form-control" onkeyup="productProviderSeeker(event)">
                    <button id="seeker_btn_search" class="btn btn-warning icon-search" onclick="productProviderSeeker('intro')"></button>
                    <button id="seeker_btn_reset" class="btn btn-danger icon-spin3 hidden" onclick="resetProduct()"></button>
                </div>
                <div id="product_provider_seeker_response"></div>
            </div>
            <div class="col-2">
                <label for="warehouse_id" class="text-light">Almacén</label>
                <?php
                    echo $graficaProveedorProducto->getWarehouses();
                ?>
            </div>
            <div class="col-2 text-center">
            <label for="date_since" class="text-light">Fecha desde</label>
                <input type="date" id="date_since" class="form-control">
            </div>
            <div class="col-2 text-center">
                <label for="date_to" class="text-light">Fecha hasta</label>
                <input type="date" id="date_to" class="form-control">
            </div>
            <div class="col-1 text-center">
                <br>
                <button class="btn btn-success" onclick="getGrafic();">
                    Generar
                </button>
            </div>
        </div>
    <div class="row principal_container">
        <div id="linea" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
        <div class="text-center row">
            <button
                class="btn btn-primary" 
                onclick="export_csv();">
                <i class="icon-download">Exportar tabla en CSV</i>
            </button>
        </div>
        <div id="table_container"></div>
    </div>
    <div class="footer bg-info text-center">
        <button class="btn btn-light icon-home" onclick="location.href='../../../../../index.php?'">
            Ir al panel
        </button>
    </div>
    
</body>
</html>

<style>
    #product_provider_seeker_response{
        position: absolute;
        width: 50%;
        height: 350px;
        background-color: white;
        box-shadow : 1px 1px 15px rgba(0,0,0,.5);
        z-index: 2;
        display : none;
        overflow: auto;
    }
    .header{

    }
    .footer{
        position : fixed;
        bottom : 0;
        width: 100%;
    }
    .principal_container{
        margin-bottom: 50px;
    }
    .seeker_row{
        box-shadow: 1px 1px 10px rgba(0,0,0,0.4);
    }
    .hidden{
        display: none;
    }
</style>