<?php
    if(isset($_POST['action']) || isset($_GET['action'])){
        include('../../../../../../conect.php');
        $graficaProveedorProducto = new graficaProveedorProducto($link);
        $action = (isset($_POST['action']) ? $_POST['action'] : $_GET['action']);
        switch($action){
            case 'productProviderSeeker':
                $txt = ( isset($_GET['txt']) ? $_GET['txt'] : $_POST['txt'] );
                $graficaProveedorProducto->productProviderSeeker( $txt );
            break;
            case 'getProductProviderGrafic' :
                $product_provider_id = (isset($_POST['product_provider']) ? $_POST['product_provider'] : $_GET['product_provider']);
                $warehouse_id = (isset($_POST['warehouse']) ? $_POST['warehouse'] : $_GET['warehouse']);
                $date_since = (isset($_POST['date_since']) ? $_POST['date_since'] : $_GET['date_since']);
                $date_to = (isset($_POST['date_to']) ? $_POST['date_to'] : $_GET['date_to']);
                echo $graficaProveedorProducto->getData($product_provider_id, $warehouse_id, $date_since, $date_to);
            break;
        }
    }
    class graficaProveedorProducto{
        private $link;
        public function __construct($connection) {
            $this->link = $connection;
        }
        public function productProviderSeeker($txt){
            $stm = null;
            $txt_array = explode(" ", $txt);
            $condition = "AND ( ";
            foreach ($txt_array as $key => $word) {
                $condition .= ( $key > 0 ? " AND" : "" );
                $condition .= " p.nombre LIKE '%{$word}%'";
            }
            $condition .= " )";
            if(is_numeric($txt)){
                $condition .= " OR pp.id_proveedor_producto LIKE '%{$txt}%'";
            }
            try{
                $sql = "SELECT
                        pp.id_proveedor_producto AS product_provider_id,
                        CONCAT( pp.id_proveedor_producto, ' - ', p.nombre, ' (', pp.clave_proveedor, ')') AS product_description
                    FROM ec_proveedor_producto pp
                    LEFT JOIN ec_productos p
                    ON p.id_productos = pp.id_producto
                    WHERE 1  
                    {$condition}
                    GROUP BY pp.id_proveedor_producto
                    ORDER BY p.orden_lista";
                $stm = $this->link->query($sql);
            }catch(PDOException $error){
                die("Error al consultar coincidencias de productos : {$sql} : {$error}");
            }
            if($stm->rowCount() <= 0){
                echo "<div class=\"text-danger\">Sin coincidencias.</div>";
            }else{
                while($row = $stm->fetch(PDO::FETCH_ASSOC)){
                    echo "<div class=\"row p-4 seeker_row\" onclick=\"setProductProvider({$row['product_provider_id']}, '{$row['product_description']}')\">
                        {$row['product_description']}
                    </div>";
                }
            }
        }
        
        public function getData($product_provider_id, $warehouse_id, $date_since, $date_to){
            $stm = null;
            try{
                $sql = "SELECT
                        ax.dates,
                        mdpp.id_almacen,
                        SUM(IF(mdpp.id_movimiento_detalle_proveedor_producto IS NULL OR mdpp.id_almacen != {$warehouse_id},0,IF(mdpp.fecha_registro <= CONCAT(ax.dates, ' 23:59:59' ),mdpp.cantidad*tm.afecta,0 ) ) ) as inventory,
                        SUM(IF((mdpp.fecha_registro BETWEEN CONCAT(ax.dates,' 00:00:01') AND CONCAT(ax.dates,' 23:59:59')) AND mdpp.id_almacen = {$warehouse_id},mdpp.cantidad*tm.afecta,0 ) ) AS movements_per_day
                    FROM(
                        SELECT
                            mdpp.id_proveedor_producto AS product_provider_id,
                            DATE_FORMAT(mdpp.fecha_registro, '%Y-%m-%d') AS dates
                        FROM ec_movimiento_detalle_proveedor_producto mdpp
                        WHERE( mdpp.fecha_registro BETWEEN '{$date_since} 00:00:01' AND '{$date_to} 23:59:59') 
                        AND mdpp.id_proveedor_producto = '{$product_provider_id}' 
                        AND mdpp.id_almacen = {$warehouse_id}
                        GROUP BY DATE_FORMAT(mdpp.fecha_registro, '%Y-%m-%d')
                    )ax
                    LEFT JOIN ec_movimiento_detalle_proveedor_producto mdpp
                    ON mdpp.id_proveedor_producto = ax.product_provider_id
                    LEFT JOIN ec_tipos_movimiento tm
                    ON tm.id_tipo_movimiento = mdpp.id_tipo_movimiento
                    WHERE mdpp.id_almacen = {$warehouse_id}
                    GROUP BY ax.dates";//die($sql);
                $stm = $this->link->query($sql);
            }catch(PDOException $error){
                die("Error al consultar datos para graficar : {$sql} : {$error}");
            }
            $dates = array();
            $inventories = array();
            $movements = array();
            while( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//mysql_fetch_row($eje)
                $dates[] = $row['dates'];
                $inventories[] = $row['inventory'];
                $movements[] = $row['movements_per_day'];
            }
            $resp = array();
            array_push($resp, array("name"=>"fecha", "data"=>$dates));
            array_push($resp, array("name"=>"movimientos", "data"=>$movements));
            array_push($resp, array("name"=>"inventario", "data"=>$inventories));
            return json_encode($resp);
        }
        public function getWarehouses(){
            $resp = "<select class=\"form-select\" id=\"warehouse_id\">
                <option>--Seleccionar--</option>";
            try{
                $sql = "SELECT id_almacen, nombre FROM ec_almacen";
                $stm = $this->link->query($sql);
                while($row = $stm->fetch(PDO::FETCH_ASSOC)){
                    $resp .= "<option value=\"{$row['id_almacen']}\">{$row['nombre']}</option>";
                }
            }catch(PDOException $error){
                die("Error al consultar almacenes : {$sql} : {$error}");
            }
            $resp .= "</select>";
            return $resp;
        }
    }
    
?>