<?php
    if(isset($_POST['action']) || isset($_GET['action'])){
        include('../../../../../../conect.php');
        $graficaProducto = new graficaProducto($link);
        $action = (isset($_POST['action']) ? $_POST['action'] : $_GET['action']);
        switch($action){
            case 'productSeeker':
                $txt = ( isset($_GET['txt']) ? $_GET['txt'] : $_POST['txt'] );
                $graficaProducto->productSeeker( $txt );
            break;
            case 'getProductGrafic' :
                $product_id = (isset($_POST['product']) ? $_POST['product'] : $_GET['product']);
                $warehouse_id = (isset($_POST['warehouse']) ? $_POST['warehouse'] : $_GET['warehouse']);
                $date_since = (isset($_POST['date_since']) ? $_POST['date_since'] : $_GET['date_since']);
                $date_to = (isset($_POST['date_to']) ? $_POST['date_to'] : $_GET['date_to']);
                echo $graficaProducto->getData($product_id, $warehouse_id, $date_since, $date_to);
            break;
        }
    }
    class graficaProducto{
        private $link;
        public function __construct($connection) {
            $this->link = $connection;
        }
        public function productSeeker($txt){
            $stm = null;
            $txt_array = explode(" ", $txt);
            $condition = "AND ( ";
            foreach ($txt_array as $key => $word) {
                $condition .= ( $key > 0 ? " AND" : "" );
                $condition .= " p.nombre LIKE '%{$word}%'";
            }
            $condition .= " )";
            if(is_numeric($txt)){
                $condition .= " OR p.orden_lista LIKE '%{$txt}%' OR p.id_productos LIKE '%{$txt}%'";
            }
            try{
                $sql = "SELECT
                        p.id_productos AS product_id,
                        CONCAT( p.id_productos, ' - ', p.nombre, ' (', p.orden_lista, ')') AS product_description
                    FROM ec_productos p
                    WHERE 1  
                    {$condition}
                    GROUP BY p.id_productos
                    ORDER BY p.orden_lista";
                $stm = $this->link->query($sql);
            }catch(PDOException $error){
                die("Error al consultar coincidencias de productos : {$sql} : {$error}");
            }
            if($stm->rowCount() <= 0){
                echo "<div class=\"text-danger\">Sin coincidencias.</div>";
            }else{
                while($row = $stm->fetch(PDO::FETCH_ASSOC)){
                    echo "<div class=\"row p-4 seeker_row\" onclick=\"setProduct({$row['product_id']}, '{$row['product_description']}')\">
                        {$row['product_description']}
                    </div>";
                }
            }
        }
        
        public function getData($product_id, $warehouse_id, $date_since, $date_to){
            $stm = null;
            try{
                $sql = "SELECT
                        ax.dates,
                        ma.id_almacen,
                        SUM(IF((ma.fecha = ax.dates) AND ma.id_almacen = {$warehouse_id},md.cantidad*tm.afecta,0 ) ) AS movements_per_day,
                        SUM(IF(md.id_movimiento_almacen_detalle IS NULL OR ma.id_almacen != {$warehouse_id},0,IF(ma.fecha <= ax.dates, md.cantidad*tm.afecta,0 ) ) ) AS inventory
                    FROM(
                        SELECT
                            md.id_producto,
                            DATE_FORMAT(ma.fecha, '%Y-%m-%d') AS dates
                        FROM ec_movimiento_detalle md
                        LEFT JOIN ec_movimiento_almacen ma 
                        ON md.id_movimiento = ma.id_movimiento_almacen
                        WHERE ( ma.fecha BETWEEN '{$date_since}' AND '{$date_to}' ) 
                        AND md.id_producto = {$product_id}
                        AND ma.id_almacen = {$warehouse_id}
                        GROUP BY DATE_FORMAT(ma.fecha, '%Y-%m-%d')
                    )ax
                    LEFT JOIN ec_movimiento_detalle md
                    ON md.id_producto = ax.id_producto
                    LEFT JOIN ec_movimiento_almacen ma 
                    ON md.id_movimiento = ma.id_movimiento_almacen
                    LEFT JOIN ec_tipos_movimiento tm
                    ON tm.id_tipo_movimiento = ma.id_tipo_movimiento
                    WHERE ma.id_almacen = {$warehouse_id}
                    GROUP BY ax.dates";
                $stm = $this->link->query($sql);
            }catch(PDOException $error){
                die("Error al consultar datos para graficar : {$sql} : {$error}");
            }
            $dates = array();
            $inventories = array();
            $movements = array();
            while( $row = $stm->fetch(PDO::FETCH_ASSOC) ) {//mysql_fetch_row($eje)
                $dates[] = $row['dates'];
                $movements[] = $row['movements_per_day'];
                $inventories[] = $row['inventory'];
            }
            $resp = array();
            array_push($resp, array("name"=>"fecha", "data"=>$dates));
            array_push($resp, array("name"=>"movimientos", "data"=>$movements));
            array_push($resp, array("name"=>"inventario", "data"=>$inventories));
            return json_encode($resp);
        }
        public function getWarehouses(){
            $resp = "<select class=\"form-select\" id=\"warehouse_id\">
                <option>--Seleccionar--</option>";
            try{
                $sql = "SELECT id_almacen, nombre FROM ec_almacen";
                $stm = $this->link->query($sql);
                while($row = $stm->fetch(PDO::FETCH_ASSOC)){
                    $resp .= "<option value=\"{$row['id_almacen']}\">{$row['nombre']}</option>";
                }
            }catch(PDOException $error){
                die("Error al consultar almacenes : {$sql} : {$error}");
            }
            $resp .= "</select>";
            return $resp;
        }
    }
    
?>