<?php
//PDF de diferencias entre cantidades solicitadas y cantidades enviadas en la transferencia
//incluye librerias
   include("../../../../conectMin.php");
   //include( "../../../../conexionMysqli.php" );
	define('FPDF_FONTPATH','../../../../include/fpdf186/font/');
	include("../../../../include/fpdf186/fpdf.php");
//Extrae rutas de tickets
	$carpeta_path = "";
	$archivo_path = "../../../../conexion_inicial.txt";
	if(file_exists($archivo_path)){
		$file = fopen($archivo_path,"r");
		$line=fgets($file);
		fclose($file);
	    $config=explode("<>",$line);
	    $tmp=explode("~",$config[2]);
	    $ruta_or=$tmp[0];
	    $ruta_des=$tmp[1];
	    $tmp_=explode("~",$config[0]);
		$carpeta_path = base64_decode( $tmp_[1] );
	}else{
		die("No hay archivo de configuración.");
	}
    $reception_block_id = $_GET['reception_block_id'];
    $tamano_alto = 0;
    $header = array();
    try{
    //consulta informacion del bloque
        $sql = "SELECT
                    t.folio,
                    s1.nombre AS origin_store,
                    s2.nombre AS destinity_store
                FROM ec_transferencias t
                LEFT JOIN ec_bloques_transferencias_validacion_detalle btvd
                ON t.id_transferencia = btvd.id_transferencia
                LEFT JOIN ec_bloques_transferencias_recepcion_detalle btrd
                ON btvd.id_bloque_transferencia_validacion = btrd.id_bloque_transferencia_validacion
                LEFT JOIN sys_sucursales s1
                ON t.id_sucursal_origen = s1.id_sucursal
                LEFT JOIN sys_sucursales s2
                ON t.id_sucursal_destino = s2.id_sucursal
                WHERE btrd.id_bloque_transferencia_recepcion = {$reception_block_id} 
                GROUP BY t.id_transferencia";
        $stm = $link->query( $sql );
        while($row = $stm->fetch(PDO::FETCH_ASSOC)){
            $header[] = $row;
        }
    }catch(PDOException $error){
        die( "Error al consultar los productos con diferencia de la transferencia : {$sql} : {$error}" );
    }

	$products = array();
	try{
    //consulta informacion del bloque
        $sql = "SELECT
                    CONCAT( '(',p.orden_lista,') ', p.nombre ) AS product_name,
                    SUM(tp.cantidad) AS quantity,
                    SUM(tp.cantidad_piezas_recibidas) AS received,
                    t.folio
                FROM ec_transferencia_productos tp
                LEFT JOIN ec_productos p
                ON tp.id_producto_or = p.id_productos
                LEFT JOIN ec_transferencias t
                ON tp.id_transferencia = t.id_transferencia
                LEFT JOIN ec_bloques_transferencias_validacion_detalle btvd
                ON t.id_transferencia = btvd.id_transferencia
                LEFT JOIN ec_bloques_transferencias_recepcion_detalle btrd
                ON btvd.id_bloque_transferencia_validacion = btrd.id_bloque_transferencia_validacion
                WHERE btrd.id_bloque_transferencia_recepcion = {$reception_block_id} 
                AND tp.cantidad != tp.cantidad_piezas_recibidas
                GROUP BY tp.id_producto_or";echo "$sql";
		$stm = $link->query( $sql );
        $tamano_alto = ($stm->rowCount() * 6);
        while($row = $stm->fetch(PDO::FETCH_ASSOC)){
            $tmp = part_word($row['product_name']);
            $row['product_name'] = $tmp[0];
            $row['product_name_2'] = $tmp[1];
            $products[] = $row;
        }
	}catch(PDOException $error){
		die( "Error al consultar los productos con diferencia de la transferencia : {$sql} : {$error}" );
	}
    //var_dump($products);
   //die("tamano_alto : {$tamano_alto}");

	class TicketPDF extends FPDF {
		// Members
		var $sucursal = "";
		var $pedido = "";
		var $inicio = 32;
	
	// Constructor
		function TicketPDF($orientation='P', $unit='mm', $size = 0, $inicio=10) {
			parent::FPDF($orientation, $unit, $size);
				
			$this->AddFont('Arial');
			$this->SetMargins(7, 0, 7);
			$this->SetDisplayMode("real", "continuous");
			$this->SetAutoPageBreak(true, -5);
			$this->inicio = $inicio;
		}
	
		// Cabecera de página
		function Header() {
		}
	
		function Footer() {
		}
	
		function AcceptPageBreak() {
			$x = $this->GetX();
			$this->AddPage();
			$this->SetXY($x, 1);
			return false;
		}
	}
	
	
	$ticket = new TicketPDF("P", "mm", array(80,(100+$tamano_alto)), 10);
	
	$ticket->AliasNbPages();
	$ticket->AddPage();
	$bF=10;

//encabezado
	$ticket->SetFont('Arial','B',$bF+2);
	$ticket->SetXY(5, 5);//$ticket->inicio
	$ticket->Cell(70, 6, mb_convert_encoding("DIFERENCIAS DE TRANSFERENCIAS.", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");

	$ticket->SetXY(5, $ticket->getY()+5);
	$ticket->Cell(70, 6, mb_convert_encoding("DE : {$header[0]['origin_store']}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	$ticket->SetXY(5, $ticket->getY()+5);
	$ticket->Cell(70, 6, mb_convert_encoding("A : {$header[0]['destinity_store']}", 'ISO-8859-1', 'UTF-8'), "" ,0, "C");
	
	$ticket->SetFont('Arial','B',$bF-1);
    $ticket->SetXY(5, $ticket->getY()+8);
	$ticket->Cell(45, 6, mb_convert_encoding("PRODUCTO", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");
    $ticket->SetXY(50, $ticket->getY());
	$ticket->Cell(12.5, 6, mb_convert_encoding("PED.", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");
    $ticket->SetXY(62.5, $ticket->getY());
	$ticket->Cell(12.5, 6, mb_convert_encoding("REC.", 'ISO-8859-1', 'UTF-8'), "0" ,0, "C");
//Productos
    foreach ($products as $key => $product) {
        $ticket->SetXY(5, $ticket->getY()+6);
        $ticket->Cell(45, 6, mb_convert_encoding("{$product['product_name']}", 'ISO-8859-1', 'UTF-8'), "0" ,0, "L");
        $ticket->SetXY(50, $ticket->getY()+3);
        $ticket->Cell(12.5, 6, mb_convert_encoding("{$product['quantity']}", 'ISO-8859-1', 'UTF-8'), "0" ,0, "R");
        $ticket->SetXY(62.5, $ticket->getY());
        $ticket->Cell(12.5, 6, mb_convert_encoding("{$product['received']}", 'ISO-8859-1', 'UTF-8'), "0" ,0, "R");
        $ticket->SetXY(5, $ticket->getY()+3);
        $ticket->Cell(45, 6, mb_convert_encoding("{$product['product_name_2']}", 'ISO-8859-1', 'UTF-8'), "0" ,0, "L");
    }
//Ruta especifica de ticket
    include( '../../../../code/especiales/controladores/SysArchivosDescarga.php' );
    $SysArchivosDescarga = new SysArchivosDescarga( $link );
    include( '../../../../code/especiales/controladores/SysModulosImpresionUsuarios.php' );
    $SysModulosImpresionUsuarios = new SysModulosImpresionUsuarios( $link );
    include( '../../../../code/especiales/controladores/SysModulosImpresion.php' );
    $SysModulosImpresion = new SysModulosImpresion( $link );
/**/
    for($cont=1;$cont<=1;$cont++){
        $nombre_ticket = "ticket_".$user_sucursal."_" . date("YmdHis") . "_.pdf";

        $ruta_salida = '';
    $ruta_salida = $SysModulosImpresionUsuarios->obtener_ruta_modulo_usuario( $user_id, 11, $rootpath );//Transferencias rapidas
        if( $ruta_salida == 'no' ){
            $ruta_salida = "cache/" . $SysModulosImpresion->obtener_ruta_modulo( $user_sucursal, 11, $rootpath );//Transferencias rapidas
        }
        $ticket->Output( "../../../../{$ruta_salida}/{$nombre_ticket}", "F" );
//Sincronización remota de tickets
        if( $user_tipo_sistema == 'linea' ){
            $registro_sincronizacion = $SysArchivosDescarga->crea_registros_sincronizacion_archivo( 11, 'pdf', $nombre_ticket, $ruta_or, $ruta_salida, $user_sucursal, $user_id, true );
        }else{//impresion por red local
            $enviar_por_red = $SysArchivosDescarga->crea_registros_sincronizacion_archivo_por_red_local( 11, 'pdf', $nombre_ticket, '', $ruta_salida, $user_sucursal, $user_id, $carpeta_path );
        }
    }
   	echo 'ok|'.$nombre_ticket;
   //}
//funcion para partir texto en 2
	function part_word( $txt ){
		$size = strlen( $txt );
		$half = round( $size / 2 );
		$words = explode(' ', $txt );
		$resp = array( '','');
		$chars_counter = 0;
		$middle_word = "";
		foreach ($words as $key => $word) {
			$is_middle = 0;
			if( $key > 0 ){
				$chars_counter ++;//espacio
				if( $chars_counter == $half ){
					$is_middle = 1;
				}
			}
			for( $i = 0; $i < strlen( $word ); $i ++ ){
				$chars_counter ++;//palabras
				if( $chars_counter == $half || $is_middle == 1){
					$middle_word = $word;
					$is_middle = 1;
				}
			}
			if( $middle_word == '' ){
				$resp[0] .= ( $resp[0] != '' ? ' ' : '' );
				$resp[0] .= $word;
			}else if( $middle_word != '' && $is_middle == 0 ){
				$resp[1] .= ( $resp[1] != '' ? ' ' : '' );
				$resp[1] .= $word;
			}
			$is_middle = 0;
		}
		if( strlen( "{$resp[0]} {$middle_word}" ) < strlen( "{$middle_word} {$resp[1]}" )  ){//asigna palabra intermedia a primera parte
			$resp[0] = "{$resp[0]} {$middle_word}";
		}else{//asigna palabra intermedia a segunda parte
			$resp[1] = "{$middle_word} {$resp[1]}";
		}
		return $resp;
	}

?>