<?php
//Version Oscar 2025-07-08 Migracion a PHP8.2
	include('../../conectMin.php');
	$link->beginTransaction();//inicia transaccion
//elimina el detalle anterior
	try{
		$sql="DELETE FROM ec_historico_estacionalidad_resumen WHERE 1";
		$link->query($sql);
	}catch(PDOException $error){
		$link->rollBack();//cancela transaccion
		die(json_encode(array("status"=>"302", "message"=>"Error al eliminar el historico anterior.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
	}
	try{
		$sql="INSERT INTO ec_historico_estacionalidad_resumen
				SELECT 
					NULL,
					e.id_sucursal,
					c.id_categoria,
					e.id_estacionalidad,
					COUNT(ep.id_estacionalidad_producto),
					SUM(ep.maximo),
					NOW(),
					'0000-00-00',
					1
			FROM ec_estacionalidad e
			LEFT JOIN ec_estacionalidad_producto ep 
			ON ep.id_estacionalidad = e.id_estacionalidad
			LEFT JOIN ec_productos p 
			ON p.id_productos = ep.id_producto
			LEFT JOIN ec_categoria c 
			ON c.id_categoria = p.id_categoria
			WHERE p.id_productos > 0 
			AND ep.maximo > 0
			AND e.id_sucursal > 1
			AND e.es_alta = 1
			AND c.id_categoria IS NOT NULL
			GROUP BY e.id_sucursal, p.id_categoria, e.id_estacionalidad
			ORDER BY e.id_sucursal";
		$link->query($sql);
	}catch(PDOException $error){
		$link->rollBack();//cancela transaccion
		die(json_encode(array("status"=>"302", "message"=>"Error al insertar el historico de estacionalidades.", "query"=>"{$sql}", "error_detail"=>"{$error->getMessage()}")));
	}
	$link->commit();//autoriza transaccion
	die('ok');
?>