/*
 * Decompiled with CFR 0.152.
 */
package sistemaimpresion.clases;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class WsDescargaArchivosClient {
    private final String wsUrl;
    private final String apiBase;
    private final String pathLocal;
    private final int idSucursal;
    private final String bearerToken;
    private final OkHttpClient client;
    private volatile WebSocket ws;
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(2);
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final ExecutorService downloader = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "http-downloader");
        t.setDaemon(true);
        return t;
    });

    public WsDescargaArchivosClient(String wsUrl, String apiBase, String pathLocal, int idSucursal, String bearerToken) {
        this.wsUrl = wsUrl;
        this.apiBase = apiBase;
        this.pathLocal = pathLocal;
        this.idSucursal = idSucursal;
        this.bearerToken = bearerToken;
        this.client = new OkHttpClient.Builder().pingInterval(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
    }

    public void start() {
        this.connectWithRetry(0L);
    }

    public void stop() {
        this.stopping.set(true);
        try {
            if (this.ws != null) {
                this.ws.close(1000, "bye");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sched.shutdownNow();
        this.downloader.shutdownNow();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
    }

    private void connectWithRetry(long delayMs) {
        this.sched.schedule(() -> {
            if (this.stopping.get()) {
                return;
            }
            Request.Builder rb = new Request.Builder().url(this.wsUrl);
            if (this.bearerToken != null && !this.bearerToken.isEmpty()) {
                rb.addHeader("Authorization", "Bearer " + this.bearerToken);
            }
            Request req = rb.build();
            this.client.newWebSocket(req, new WebSocketListener(){
                private long backoff = 1000L;
                private long max = 30000L;

                public void onOpen(WebSocket webSocket, Response response) {
                    WsDescargaArchivosClient.this.ws = webSocket;
                    this.backoff = 1000L;
                    WsDescargaArchivosClient.this.sendJson(new JSONObject().put("type", (Object)"HELLO").put("client", (Object)"java-print-agent").put("version", (Object)"1.0"));
                    WsDescargaArchivosClient.this.sendJson(new JSONObject().put("type", (Object)"SUBSCRIBE").put("destinity_store_id", WsDescargaArchivosClient.this.idSucursal));
                }

                public void onMessage(WebSocket webSocket, String text) {
                    try {
                        JSONObject msg = new JSONObject(text);
                        String type = msg.optString("type", "");
                        if ("NEW_FILES".equals(type)) {
                            JSONArray files = msg.optJSONArray("files");
                            if (files != null && files.length() > 0) {
                                WsDescargaArchivosClient.this.downloader.submit(() -> WsDescargaArchivosClient.this.processFiles(files));
                            }
                        } else if ("PING".equals(type)) {
                            WsDescargaArchivosClient.this.sendJson(new JSONObject().put("type", (Object)"PONG"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response r) {
                    if (WsDescargaArchivosClient.this.stopping.get()) {
                        return;
                    }
                    long jitter = ThreadLocalRandom.current().nextLong(Math.max(1L, this.backoff / 5L));
                    long delay = Math.min(this.backoff + jitter, this.max);
                    this.backoff = Math.min((long)((double)this.backoff * 1.7), this.max);
                    WsDescargaArchivosClient.this.connectWithRetry(delay);
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    if (WsDescargaArchivosClient.this.stopping.get()) {
                        return;
                    }
                    WsDescargaArchivosClient.this.connectWithRetry(2000L);
                }
            });
        }, Math.max(0L, delayMs), TimeUnit.MILLISECONDS);
    }

    private void sendJson(JSONObject obj) {
        WebSocket s = this.ws;
        if (s != null) {
            s.send(obj.toString());
        }
    }

    private void processFiles(JSONArray files) {
        ArrayList<String> okIds = new ArrayList<String>();
        for (int i = 0; i < files.length(); ++i) {
            JSONObject f = files.getJSONObject(i);
            String originBase = f.getString("file_origin");
            String destRelDir = f.getString("file_destinity");
            String fileName = f.getString("file_name");
            String fileId = f.getString("file_id");
            String originUrl = originBase.replace("http://", "https://") + fileName;
            try {
                Path out = this.downloadHttp(originUrl, destRelDir, fileName);
                if (out == null) continue;
                okIds.add(fileId);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!okIds.isEmpty()) {
            try {
                String joined = String.join((CharSequence)",", okIds);
                this.postActualizaStatus(joined);
                this.sendJson(new JSONObject().put("type", (Object)"ACK_UPDATE").put("ok_rows", (Object)joined));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Path downloadHttp(String originUrl, String destRelDir, String fileName) throws IOException {
        Path dir = Paths.get(this.pathLocal, destRelDir);
        Files.createDirectories(dir, new FileAttribute[0]);
        Path target = dir.resolve(fileName);
        URL url = new URL(originUrl);
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setConnectTimeout(8000);
        c.setReadTimeout(20000);
        c.setInstanceFollowRedirects(true);
        c.setRequestProperty("Accept-Encoding", "gzip");
        int code = c.getResponseCode();
        if (code != 200) {
            throw new IOException("HTTP " + code + " al descargar " + originUrl);
        }
        InputStream in = c.getInputStream();
        String enc = c.getContentEncoding();
        if (enc != null && enc.toLowerCase().contains("gzip")) {
            in = new GZIPInputStream(in);
        }
        try (BufferedInputStream bis = new BufferedInputStream(in, 65536);
             OutputStream out = Files.newOutputStream(target, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int n;
            byte[] buf = new byte[65536];
            while ((n = bis.read(buf)) >= 0) {
                out.write(buf, 0, n);
            }
        }
        return target;
    }

    private void postActualizaStatus(String okRowsCsv) throws IOException {
        URL url = new URL(this.apiBase + "/actualizar_status_archivos");
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setRequestMethod("POST");
        c.setConnectTimeout(8000);
        c.setReadTimeout(15000);
        c.setDoOutput(true);
        c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        String body = "ok_rows=" + URLEncoder.encode(okRowsCsv, "UTF-8");
        try (OutputStream os = c.getOutputStream();){
            os.write(body.getBytes("UTF-8"));
        }
        int code = c.getResponseCode();
        if (code != 200) {
            throw new IOException("HTTP " + code + " al actualizar ok_rows");
        }
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(c.getInputStream(), "UTF-8"));){
            while (rd.readLine() != null) {
            }
        }
    }
}

