/*
 * Decompiled with CFR 0.152.
 */
package sistemaimpresion.clases;

import java.awt.Color;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONException;
import org.json.JSONObject;
import sistemaimpresion.clases.DescargaArchivos;
import sistemaimpresion.form.informeImpresiones;

public class WebSocketClient {
    private OkHttpClient client;
    private DescargaArchivos descarga_archivos;
    private int id_sucursal;
    private int intervalo_reconexion_ws;
    private int limite_reconexion_ws;
    private String url;
    private String IP_ID_WEBSOCKET;
    private static final int MAX_RETRIES = 100;
    private int retryCount = 0;
    private informeImpresiones form;

    public WebSocketClient(DescargaArchivos descarga_archivos, int id_sucursal, String IP_ID_WEBSOCKET, int intervalo_reconexion_ws, int limite_reconexion_ws, informeImpresiones form) {
        this.descarga_archivos = descarga_archivos;
        this.id_sucursal = id_sucursal;
        this.IP_ID_WEBSOCKET = IP_ID_WEBSOCKET;
        this.intervalo_reconexion_ws = intervalo_reconexion_ws;
        this.limite_reconexion_ws = limite_reconexion_ws;
        this.form = form;
    }

    public void start(String url) {
        this.url = url;
        this.connect();
    }

    private void connect() {
        this.client = new OkHttpClient.Builder().pingInterval(15L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(this.url).build();
        WebSocketListener listener = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                WebSocketClient.this.retryCount = 0;
                System.out.println("Conectado al servidor");
                WebSocketClient.this.form;
                informeImpresiones.websocket_status.setText("Conectado");
                WebSocketClient.this.form;
                informeImpresiones.websocket_status.setForeground(Color.GREEN);
                JSONObject hello = new JSONObject().put("type", (Object)"HELLO").put("payload", (Object)new JSONObject().put("client", (Object)"java-example").put("version", (Object)"1.0"));
                webSocket.send(hello.toString());
                JSONObject subscribe = new JSONObject().put("type", (Object)"SUBSCRIBE").put("payload", (Object)new JSONObject().put("topic", (Object)"print_jobs").put("store_id", 1));
                webSocket.send(subscribe.toString());
            }

            public void onMessage(WebSocket webSocket, String text) {
                try {
                    JSONObject msg = new JSONObject(text);
                    String type = msg.optString("type", "");
                    String file_id_ = msg.optString("file_id", "");
                    String file_origin_path = msg.optString("file_origin_path", "");
                    String file_destinity_path = msg.optString("file_destinity_path", "");
                    String file_name = msg.optString("file_name", "");
                    int file_id = Integer.parseInt(file_id_);
                    JSONObject payload = msg.optJSONObject("payload");
                    System.out.println("JSON recibido: " + msg.toString());
                    String download = WebSocketClient.this.descarga_archivos.descarga_archivos(file_origin_path, file_destinity_path, file_name);
                    if (download.equals("ok")) {
                        WebSocketClient.this.descarga_archivos.actualiza_descarga_archivo("" + file_id);
                    } else {
                        System.out.println("Error al descargar el archivo : " + download);
                    }
                }
                catch (JSONException e) {
                    System.err.println("No es JSON v\u00e1lido: " + text);
                }
                catch (IOException ex) {
                    Logger.getLogger(WebSocketClient.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                System.out.println("Binario recibido (" + bytes.size() + " bytes). Ignorando.");
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                WebSocketClient.this.form;
                informeImpresiones.websocket_status.setText("Desconectado");
                WebSocketClient.this.form;
                informeImpresiones.websocket_status.setForeground(Color.RED);
                System.out.println("Cerrando conexi\u00f3n: " + code + " / " + reason);
                webSocket.close(1000, null);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                System.out.println("Conexi\u00f3n cerrada: " + code + " / " + reason);
                WebSocketClient.this.form;
                informeImpresiones.websocket_status.setText("Desconectado");
                WebSocketClient.this.form;
                informeImpresiones.websocket_status.setForeground(Color.RED);
                WebSocketClient.this.handleReconnection();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                System.err.println("Error en WebSocket: " + t.getMessage());
                WebSocketClient.this.handleReconnection();
            }
        };
        this.client.newWebSocket(request, listener);
    }

    private void handleReconnection() {
        if (this.retryCount < this.limite_reconexion_ws) {
            informeImpresiones.websocket_status.setText("Recontectando...");
            informeImpresiones.websocket_status.setForeground(Color.ORANGE);
            ++this.retryCount;
            System.out.println("Intentando reconectar... (" + this.retryCount + "/" + this.limite_reconexion_ws + ")");
            try {
                TimeUnit.SECONDS.sleep(this.intervalo_reconexion_ws);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.connect();
        } else {
            System.out.println("Se alcanz\u00f3 el m\u00e1ximo de intentos de reconexi\u00f3n.");
        }
    }
}

