/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONException;
import org.json.JSONObject;

public class EjemploWebSocketCliente {
    private OkHttpClient client;

    public void start(String url) {
        this.client = new OkHttpClient.Builder().pingInterval(15L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        WebSocketListener listener = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                System.out.println("Conectado al servidor");
                JSONObject hello = new JSONObject().put("type", (Object)"HELLO").put("payload", (Object)new JSONObject().put("client", (Object)"java-example").put("version", (Object)"1.0"));
                webSocket.send(hello.toString());
                JSONObject subscribe = new JSONObject().put("type", (Object)"SUBSCRIBE").put("payload", (Object)new JSONObject().put("topic", (Object)"print_jobs").put("store_id", 1));
                webSocket.send(subscribe.toString());
            }

            public void onMessage(WebSocket webSocket, String text) {
                try {
                    JSONObject msg = new JSONObject(text);
                    String type = msg.optString("type", "");
                    JSONObject payload = msg.optJSONObject("payload");
                    System.out.println("JSON recibido: " + msg.toString());
                    switch (type) {
                        case "WELCOME": {
                            System.out.println("Servidor dio la bienvenida.");
                            break;
                        }
                        case "NEW_FILES": {
                            break;
                        }
                        case "PING": {
                            webSocket.send(new JSONObject().put("type", (Object)"PONG").toString());
                            break;
                        }
                        default: {
                            System.out.println("Tipo no reconocido: " + type);
                            break;
                        }
                    }
                }
                catch (JSONException e) {
                    System.err.println("No es JSON v\u00e1lido: " + text);
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                System.out.println("Binario recibido (" + bytes.size() + " bytes). Ignorando.");
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                System.out.println("Cerrando conexi\u00f3n: " + code + " / " + reason);
                webSocket.close(1000, null);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                System.out.println("Conexi\u00f3n cerrada: " + code + " / " + reason);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                System.err.println("Error en WebSocket: " + t.getMessage());
            }
        };
        this.client.newWebSocket(request, listener);
    }

    public static void main(String[] args) {
        String wsUrl = "ws://localhost:8081/?user_id=1&store_id=1&user_type=print_client";
        new EjemploWebSocketCliente().start(wsUrl);
    }
}

