/*
 * Decompiled with CFR 0.152.
 */
package sistemaimpresion.clases;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import sistemaimpresion.clases.Carpetas;
import sistemaimpresion.form.ConfiguracionFormulario;

public class Configuracion {
    String URL_API;

    public Configuracion() {
    }

    public Configuracion(String urlApi) {
        this.URL_API = urlApi;
    }

    public String obtenerUrlApi() {
        return "";
    }

    public void consumirApiConfiguracion() throws MalformedURLException, IOException {
        String linea;
        String urlParaVisitar = this.URL_API;
        StringBuilder resultado = new StringBuilder();
        URL url = new URL(urlParaVisitar + "/rest/print/obtener_configuracion_impresion");
        HttpURLConnection conexion = (HttpURLConnection)url.openConnection();
        conexion.setRequestMethod("POST");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conexion.getInputStream()));
        while ((linea = rd.readLine()) != null) {
            resultado.append(linea);
        }
        rd.close();
        String tmp = resultado.toString();
    }

    public String solicitarUrlApi() throws IOException, ParseException {
        Object[] sucursales = new Object[]{"0 - Seleccionar Sucursal", "1 - Matriz", "2 - San Miguel", "3 - Trojes", "4 - Casa", "5 - Checo", "6 - Palma", "7 - Viveros", "8 - Lopez", "9 - Lago", "10 - Centro Urbano", "11 - Satelite"};
        Object opcion = JOptionPane.showInputDialog(null, "Selecciona una sucursal", "Elegir", 3, null, sucursales, sucursales[0]);
        while (opcion.toString().equals(null) || opcion.toString().equals("0 - Seleccionar Sucursal")) {
            opcion = JOptionPane.showInputDialog(null, "Selecciona una sucursal", "Elegir", 3, null, sucursales, sucursales[0]);
        }
        String[] sucursal = opcion.toString().split(" - ");
        this.URL_API = "";
        Boolean url_valida = false;
        while (!url_valida.booleanValue()) {
            this.URL_API = JOptionPane.showInputDialog("Ingresa la URL del API de Configuraci\u00f3n");
            if (this.URL_API == "" || !this.URL_API.contains("http://") && !this.URL_API.contains("https://")) {
                JOptionPane.showMessageDialog(null, "La url '" + this.URL_API + "' es incrorrecta en !");
                url_valida = false;
                continue;
            }
            url_valida = this.validaUrlApi(this.URL_API, sucursal);
        }
        return this.URL_API;
    }

    public Boolean validaUrlApi(String url_api, String[] sucursal) throws MalformedURLException, ProtocolException, IOException, ParseException {
        String urlParaVisitar = url_api;
        StringBuilder resultado = new StringBuilder();
        URL url = new URL(urlParaVisitar + "/rest/print/obtener_configuracion_impresion");
        try {
            String linea;
            HttpURLConnection conexion = (HttpURLConnection)url.openConnection();
            conexion.setRequestMethod("POST");
            String urlParameters = "id_sucursal=" + sucursal[0];
            conexion.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(conexion.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conexion.getInputStream()));
            while ((linea = rd.readLine()) != null) {
                resultado.append(linea);
            }
            rd.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "La url '" + url + "' es incrorrecta!" + resultado);
            return false;
        }
        String tmp = resultado.toString();
        System.out.println("Reg pendientes : " + tmp);
        JSONObject JArray = new JSONObject(tmp);
        if (JArray.getString("message").equals("ok")) {
            this.crearArchivoConfiguracion(JArray, sucursal);
            return true;
        }
        return false;
    }

    public Boolean crearArchivoConfiguracion(JSONObject Arreglo, String[] sucursal) throws IOException, ParseException {
        String path = "config_impresion.json";
        JSONObject json = new JSONObject();
        try {
            json.put("tipo_impresion", (Object)"2");
            json.put("url_api", (Object)this.URL_API);
            json.put("intervalo_impresion", (Object)"3");
            json.put("intervalo_descarga", (Object)"30");
            json.put("puerto_impresion", (Object)"1337");
            json.put("path_local", (Object)"");
            json.put("id_sucursal", (Object)sucursal[0]);
            json.put("nombre_sucursal", (Object)sucursal[1]);
            json.put("url_api_local", (Object)"");
            json.put("modulos", (Object)Arreglo.getJSONArray("modulos"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(path));){
            out.write(json.toString(2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cargarConfiguracion();
        return true;
    }

    public void cargarConfiguracion() throws FileNotFoundException, IOException, ParseException {
        ConfiguracionFormulario formulario = new ConfiguracionFormulario();
        JSONParser parser = new JSONParser();
        FileReader reader = new FileReader("config_impresion.json");
        Object obj = parser.parse((Reader)reader);
        JSONObject configuraciones = new JSONObject(obj.toString());
        String tipo_impresion = configuraciones.getString("tipo_impresion");
        String url_api = configuraciones.getString("url_api");
        String intervalo_impresion = configuraciones.getString("intervalo_impresion");
        String intervalo_descarga = configuraciones.getString("intervalo_descarga");
        String puerto_impresion = configuraciones.getString("puerto_impresion");
        String path_local = configuraciones.getString("path_local");
        String id_sucursal = configuraciones.getString("id_sucursal");
        String nombre_sucursal = configuraciones.getString("nombre_sucursal");
        String url_api_local = configuraciones.getString("url_api_local");
        String sucursal = id_sucursal + " - " + nombre_sucursal;
        Carpetas carpetas = new Carpetas(path_local, url_api);
        JSONArray modulos = new JSONArray(configuraciones.getJSONArray("modulos"));
        for (int i = 0; i < modulos.length(); ++i) {
            JSONObject contenido_modulos = new JSONObject(modulos.get(i).toString());
            Boolean habilitado = contenido_modulos.getString("habilitado").equals("1");
            ConfiguracionFormulario.modelo_tabla_impresoras.addRow(new Object[]{contenido_modulos.getString("nombre_modulo"), contenido_modulos.getString("usuario"), contenido_modulos.getString("ruta"), contenido_modulos.getString("impresora"), contenido_modulos.getString("extension_archivo"), contenido_modulos.getString("comando_impresion"), habilitado, contenido_modulos.getString("endpoint_api_destino")});
            carpetas.verificacion_existencia_carpeta(contenido_modulos.getString("ruta"));
        }
        if (tipo_impresion.equals("2")) {
            ConfiguracionFormulario.tipo_impresion_2.setSelected(true);
            ConfiguracionFormulario.tipo_impresion_3.setSelected(false);
        } else if (tipo_impresion.equals("3")) {
            ConfiguracionFormulario.tipo_impresion_2.setSelected(false);
            ConfiguracionFormulario.tipo_impresion_3.setSelected(true);
        } else {
            ConfiguracionFormulario.tipo_impresion_2.setSelected(false);
            ConfiguracionFormulario.tipo_impresion_3.setSelected(false);
        }
        ConfiguracionFormulario.path_api_local.setText(url_api_local);
        ConfiguracionFormulario.url_api_general.setText(url_api);
        ConfiguracionFormulario.intervalo_local.setText(intervalo_impresion);
        ConfiguracionFormulario.intervalo_busqueda.setText(intervalo_descarga);
        ConfiguracionFormulario.puerto_impresion.setText(puerto_impresion);
        ConfiguracionFormulario.path_local.setText(path_local);
        ConfiguracionFormulario.id_sucursal.setSelectedItem(sucursal);
        formulario.setVisible(true);
    }

    public static HashMap<String, Object> obtenerValoresConfiguracion() throws FileNotFoundException, IOException, ParseException {
        ConfiguracionFormulario formulario = new ConfiguracionFormulario();
        HashMap<String, Object> arreglo_configuracion = new HashMap<String, Object>();
        JSONParser parser = new JSONParser();
        FileReader reader = new FileReader("config_impresion.json");
        Object obj = parser.parse((Reader)reader);
        JSONObject configuraciones = new JSONObject(obj.toString());
        arreglo_configuracion.put("tipo_impresion", configuraciones.getString("tipo_impresion"));
        arreglo_configuracion.put("url_api", configuraciones.getString("url_api"));
        arreglo_configuracion.put("intervalo_impresion", configuraciones.getString("intervalo_impresion"));
        arreglo_configuracion.put("intervalo_descarga", configuraciones.getString("intervalo_descarga"));
        arreglo_configuracion.put("path_local", configuraciones.getString("path_local"));
        arreglo_configuracion.put("puerto_impresion", configuraciones.getString("puerto_impresion"));
        arreglo_configuracion.put("nombre_sucursal", configuraciones.getString("nombre_sucursal"));
        arreglo_configuracion.put("id_sucursal", configuraciones.getString("id_sucursal"));
        arreglo_configuracion.put("url_api_local", configuraciones.getString("url_api_local"));
        JSONArray modulos = new JSONArray(configuraciones.getJSONArray("modulos"));
        HashMap arreglo_impresoras = new HashMap();
        int contador_impresoras = 0;
        for (int i = 0; i < modulos.length(); ++i) {
            JSONObject contenido_modulos = new JSONObject(modulos.get(i).toString());
            Boolean habilitado = contenido_modulos.getString("habilitado").equals("1");
            HashMap<String, String> impresora = new HashMap<String, String>();
            if (!habilitado.booleanValue()) continue;
            String llave = "impresora_" + contador_impresoras;
            impresora.put("nombre_modulo", contenido_modulos.getString("nombre_modulo"));
            impresora.put("usuario", contenido_modulos.getString("usuario"));
            impresora.put("ruta", contenido_modulos.getString("ruta"));
            impresora.put("impresora", contenido_modulos.getString("impresora"));
            impresora.put("extension_archivo", contenido_modulos.getString("extension_archivo"));
            impresora.put("comando_impresion", contenido_modulos.getString("comando_impresion"));
            impresora.put("endpoint_api_destino", contenido_modulos.getString("endpoint_api_destino"));
            arreglo_impresoras.put(llave, impresora);
            ++contador_impresoras;
        }
        arreglo_configuracion.put("printers", arreglo_impresoras);
        return arreglo_configuracion;
    }
}

