/*
 * Decompiled with CFR 0.152.
 */
package sistemaimpresion.clases;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import sistemaimpresion.form.informeImpresiones;

public class BarridoImpresion {
    private String path_local;

    public BarridoImpresion(String path) {
        this.path_local = path;
    }

    public void BarreCarpeta(String comando, String nombre, String ruta_tkt, String extension, int antiguedad_archivos, Boolean convertir_a_img, String pdftoppm_path) throws InterruptedException, IOException {
        String path = this.path_local + "/" + ruta_tkt + "/";
        String osName = System.getProperty("os.name");
        File folder = new File(path);
        boolean es_windows = osName.contains("Windows");
        if (folder.exists()) {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles.length > 0) {
                for (int i = 0; i < listOfFiles.length; ++i) {
                    if (!listOfFiles[i].isFile()) continue;
                    String files = listOfFiles[i].getName();
                    Path path1 = Paths.get(this.path_local + "/" + ruta_tkt + "/" + files, new String[0]);
                    BasicFileAttributes attrs = Files.readAttributes(path1, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime creationTime = attrs.creationTime();
                    Instant creationInstant = creationTime.toInstant();
                    Instant now = Instant.now();
                    Duration duration = Duration.between(creationInstant, now);
                    File file = new File(path + files);
                    File imagen_convertida = null;
                    String imagen_convertida_str = "";
                    if (!files.endsWith(extension.toUpperCase()) && !files.endsWith(extension.toLowerCase())) continue;
                    if (duration.getSeconds() >= (long)antiguedad_archivos) {
                        String command = comando;
                        if (extension.toLowerCase().equals("pdf") && convertir_a_img.equals(true)) {
                            String comando_conversion = pdftoppm_path + "pdftoppm -jpeg {ARCHIVO} {ARCHIVO}";
                            comando_conversion = comando_conversion.replace("{ARCHIVO}", path + files);
                            try {
                                String linea;
                                informeImpresiones.informeImpresion.append("Convirtiendo archivo: " + path + files);
                                informeImpresiones.informeImpresion.append("\nComando: " + comando_conversion);
                                System.out.println("\nComando: " + comando_conversion);
                                path = path.replace("\\", "\\\\");
                                Process proceso_conversion = Runtime.getRuntime().exec(comando_conversion);
                                BufferedReader reader = new BufferedReader(new InputStreamReader(proceso_conversion.getInputStream()));
                                while ((linea = reader.readLine()) != null) {
                                }
                                System.out.println("Pasa 1");
                                BufferedReader errorReader = new BufferedReader(new InputStreamReader(proceso_conversion.getErrorStream()));
                                while ((linea = errorReader.readLine()) != null) {
                                    System.err.println(linea);
                                }
                                proceso_conversion.waitFor();
                                System.out.println("Pasa 2");
                                if (proceso_conversion.exitValue() == 0) {
                                    file.delete();
                                    informeImpresiones.informeImpresion.append("\nEliminando archivo: " + path + files + "\n");
                                } else {
                                    informeImpresiones.informeImpresion.append("\nError al convertir archivo : " + command + " :: " + proceso_conversion.exitValue() + "\n");
                                }
                                imagen_convertida_str = files = files + "-1.jpg";
                                imagen_convertida = new File(path + imagen_convertida_str);
                                System.out.println("files : " + files);
                            }
                            catch (IOException ioe) {
                                System.out.println("Error al convertir : " + ioe);
                            }
                        }
                        if (es_windows) {
                            path = path.replace("/", "\\");
                        }
                        command = command.replace("{IMPRESORA}", nombre);
                        command = command.replace("{ARCHIVO}", path + files);
                        try {
                            String linea;
                            informeImpresiones.informeImpresion.append("\nImprimiendo archivo: " + path + files);
                            informeImpresiones.informeImpresion.append("\nComando: " + command);
                            path = path.replace("\\", "\\\\");
                            Process proceso = Runtime.getRuntime().exec(command);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(proceso.getInputStream()));
                            while ((linea = reader.readLine()) != null) {
                            }
                            BufferedReader errorReader = new BufferedReader(new InputStreamReader(proceso.getErrorStream()));
                            while ((linea = errorReader.readLine()) != null) {
                                System.err.println(linea);
                            }
                            proceso.waitFor();
                            if (proceso.exitValue() == 0) {
                                if (extension.toLowerCase().equals("pdf") && convertir_a_img.equals(true)) {
                                    imagen_convertida.delete();
                                    informeImpresiones.informeImpresion.append("\nEliminando imagen : " + path + imagen_convertida + "\n");
                                    continue;
                                }
                                file.delete();
                                informeImpresiones.informeImpresion.append("\nEliminando archivo : " + path + files + "\n");
                                continue;
                            }
                            informeImpresiones.informeImpresion.append("\nError al imprimir archivo : " + command + " :: " + proceso.exitValue() + "\n");
                        }
                        catch (IOException ioe) {
                            System.out.println("Error al imprimir : " + ioe);
                        }
                        continue;
                    }
                    System.out.println("No han pasado " + antiguedad_archivos + " segundos desde la creaci\u00f3n del archivo.");
                }
            }
        } else {
            informeImpresiones.informeImpresion.append("La ruta : " + folder + " no existe\n");
        }
    }
}

